/* CHMtools v0.1 */
/* Copyright 2001 Matthew T. Russotto */
/*  
    This file is part of CHMtools

    CHMtools is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    CHMtools is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>

typedef struct guid_t
{
  ULONG guid1;
  UWORD guid2[2];
  UBYTE guid3[8];
} guid_t;

typedef struct chmheader {
  char itsf[4];
  ULONG version; /* CHMTools only deals with version 3 */
  ULONG tot_hdrlen; /*  0x60 in version 3 */
  ULONG unk3; /* always 0x01 */
  ULONG last_modified; /* format unknown */
  ULONG langid; /* usually 0x0409 (ENGLISH_US); I've seen 0x0407 (GERMAN_GERMAN) */
  guid_t unk_guid1; /* 7C01FD10-7BAA-11D0-9E0C-00A0-C922-E6EC */
  guid_t unk_guid2; /* 7C01FD11-7BAA-11D0-9E0C-00A0-C922-E6EC */
} chmheader;

typedef struct hsecentry {
  ULONG offset;
  ULONG offset_hi; /* note that CHMLib does not support >4GB files */
  ULONG length;
  ULONG length_hi; 
} hsecentry;

typedef hsecentry hsectable[2];

typedef struct hsec1_t {
  ULONG unk1; /* 0x1FE */
  ULONG unk2; /* 0 */
  ULONG file_length;
  ULONG file_length_hi;
} hsec1_t;

typedef struct dirheader {
  char itsp[4];
  ULONG unk1;        /* 0x01 */
  ULONG length;      /* 0x54 */
  ULONG unk3;        /* 0x0a */
  ULONG chunksize;   /* 0x1000 */
  ULONG unk5;        /* 0x02 */
  ULONG tree_depth;        /* 1 if there is no index chunk, 2 if there is one.  CHMTools does not handle higher numbers */
  ULONG indexchunk;  /* -1 if none, but 0 (probably erroneously) in at least one file */
  ULONG firstpmglchunk; 
  ULONG lastpmglchunk;
  ULONG unk8;        /* 0xFFFFFFFF */
  ULONG ndirchunks;
  ULONG langid;        /* 0x0409 (again?) */
  guid_t unk_guid1;   /* 5D02926A-212E-11D0-9DF9-00A0C922E6EC */
  ULONG unk10;       /* 0x54 */
  ULONG unk11[3];    /* 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF */
} dirheader;

typedef struct pmglchunkheader {
  char pmgl[4];
  ULONG quickreflen; /* length of the quickref area at the end of section */
  ULONG unk1; /* 0   probably intended to be this_chunk, but not necessary
		 because this_chunk is defined by position */
  ULONG prev_chunk;
  ULONG next_chunk;
} pmglchunkheader;

typedef struct direntry
{
  ULONG section;
  ULONG offset;
  ULONG length;
  char name[256];
} direntry;

typedef struct chm_dir {
  int nentries;
  direntry entry[1];
} chm_dir;

typedef struct contsecentry {
  char name[256];
  int offset;
  short iscompressed;
  UBYTE *cache;
  ULONG cachesize;
} contsecentry;

typedef struct contsecs {
  int nentries;
  struct contsecentry entry[1];
} contsecs;

typedef struct chmfile
{
  FILE *cf;
  chmheader ch;
  hsectable hs;
  contsecs *cs;
  dirheader dh;
  chm_dir *dir;
  ULONG file_length;
  ULONG content_offset;
} chmfile;


int 
chm_getfile(chmfile *c, char *name, ULONG *length,
	    UBYTE **outbuf);

chmfile *chm_openfile(char *fname);

void
chm_close(chmfile *l);

void
chm_free(void *b);
