/*
 * Decompiled with CFR 0.152.
 */
package testsuite;

import java.sql.Connection;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.gjt.mm.mysql.jdbc2.optional.MysqlDataSource;

public class JNDIDataSource {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals("install")) {
            try {
                JNDIDataSource.registerDataSource();
                System.out.println("Data source 'jdbc/test' installed.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Install failed.");
            }
            return;
        }
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.addToEnvironment("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
            DataSource dataSource = (DataSource)initialContext.lookup("/tmp/jdbc/test");
            Connection connection = dataSource.getConnection("root", "eggs/ez");
            System.out.println("Connection is: " + connection);
            connection.close();
            System.out.println("Done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void registerDataSource() throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
        InitialContext initialContext = new InitialContext(hashtable);
        System.out.println("Context is: " + initialContext);
        MysqlDataSource mysqlDataSource = new MysqlDataSource();
        System.out.println("DataSource is: " + mysqlDataSource);
        mysqlDataSource.setServerName("localhost");
        mysqlDataSource.setDatabaseName("test");
        mysqlDataSource.setUser("root");
        mysqlDataSource.setPassword("eggs/ez");
        initialContext.bind("/tmp/jdbc/test", (Object)mysqlDataSource);
        initialContext.close();
    }
}

