/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.l10nZilla.Phrase;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.l10nZilla;
import org.l10nZilla.writer.mozDBWriter;

public class translator {
    private String srcLangCode;
    private String trgtLangCode;
    private int preferredInstallId = 0;
    private int numberOfStrings = 0;
    private int numberOfSuccessfulTranslatedStrings = 0;
    private int numberOfStringsTranslatedInOtherInstalls = 0;
    private int numberOfStringsTranslatedOnIdenticalText = 0;
    private int numberOfNewStrings = 0;
    private int numberOfUntranslatedString = 0;
    private int numberOfIgnoredCommandKeys = 0;
    private int numberOfIgnoredAcessKeys = 0;
    private boolean printedFileNameFlag = false;
    private Connection dbConn;
    private Statement stmt;
    private PreparedStatement prepAttempt1;
    private PreparedStatement prepAttempt2;
    private PreparedStatement prepAttempt3;
    private boolean logTranslationToDB = false;
    private mozDBWriter translationsDBWriter = null;
    private TranslationFile currentFile;

    public translator(String dictionaryAddress, String sourceLanguageCode, String targetLanguageCode) {
        this.srcLangCode = sourceLanguageCode;
        this.trgtLangCode = targetLanguageCode;
        try {
            String strSQL = null;
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
            this.dbConn = DriverManager.getConnection(dictionaryAddress);
            strSQL = "select TranslatedText_ID, TranslatedString , SourceText_ID, Label_ID, Quality_ID ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" from Temp_Installs_Translations");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" where File_Name=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and File_Location=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and Label_Name=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and SourceString=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" order by Quality_ID");
            this.prepAttempt1 = this.dbConn.prepareStatement(strSQL);
            strSQL = "select ilst.TranslatedText_ID, t.TranslatedString from Installs_Labels_Source_Target as ilst, ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" Installs_Labels_Source as ils , TranslatedTexts as t, SourceTexts as s, Labels as l, Files as f ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" where f.File_Name=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and f.File_Location=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and l.Label_ID=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and l.Label_ID = ils.Label_ID ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and s.SourceString=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and s.SourceText_ID=ils.SourceText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ils.SourceText_ID=ilst.SourceText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ilst.Lang_ID=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ilst.TranslatedText_ID = t.TranslatedText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" order by t.Quality_ID");
            this.prepAttempt2 = this.dbConn.prepareStatement(strSQL);
            strSQL = "select ilst.TranslatedText_ID, ilst.Label_ID, ilst.SourceText_ID, t.TranslatedString from Installs_Labels_Source_Target as ilst, ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" Installs_Labels_Source as ils , TranslatedTexts as t, SourceTexts as s ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" where s.SourceString=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and s.SourceText_ID=ils.SourceText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ils.SourceText_ID=ilst.SourceText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ilst.Lang_ID=?");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ilst.TranslatedText_ID = t.TranslatedText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" order by t.Quality_ID");
            this.prepAttempt3 = this.dbConn.prepareStatement(strSQL);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public void translatePhrase(Phrase sourcePhrase, Phrase translatedPhrase) {
        String strSQL = "";
        ++this.numberOfStrings;
        int qualityId = 0;
        try {
            if (sourcePhrase.getKey().equalsIgnoreCase("lang.version") || sourcePhrase.getKey().endsWith("commandkey") || sourcePhrase.getKey().endsWith("Commandkey") || sourcePhrase.getKey().endsWith("commandKey") || sourcePhrase.getKey().endsWith("Commandkey") || sourcePhrase.getKey().endsWith(".key") || sourcePhrase.getKey().endsWith(".Key") || sourcePhrase.getKey().endsWith("keybinding")) {
                translatedPhrase.setKey(sourcePhrase.getKey());
                translatedPhrase.setText(sourcePhrase.getText());
                translatedPhrase.setTranslation(sourcePhrase.getText());
                System.out.println("**Command Key ignored**");
                System.out.println(sourcePhrase.getKey());
                ++this.numberOfIgnoredCommandKeys;
            } else {
                this.prepAttempt1.setString(1, this.currentFile.getFileName());
                this.prepAttempt1.setString(2, this.currentFile.getFilePath());
                this.prepAttempt1.setString(3, sourcePhrase.getKey());
                String textString = this.replaceQuote(sourcePhrase.getText());
                this.prepAttempt1.setString(4, textString);
                ResultSet srcTextRecord = this.prepAttempt1.executeQuery();
                if (srcTextRecord.next()) {
                    translatedPhrase.setKey(sourcePhrase.getKey());
                    translatedPhrase.setText(sourcePhrase.getText());
                    String enc_textString = srcTextRecord.getString("TranslatedString");
                    qualityId = srcTextRecord.getInt("Quality_ID");
                    translatedPhrase.setTranslation(enc_textString);
                    if (this.isPhraseReallyTranslated(translatedPhrase)) {
                        translatedPhrase.setTranslationQuality(l10nZilla.ATTEMPT_1_TRANSLATION_QUALITYID, "Attempt 1 Match");
                        ++this.numberOfSuccessfulTranslatedStrings;
                    } else {
                        translatedPhrase.setTranslationQuality(l10nZilla.QUALITY_UNKNOWN, "Quality Unknown");
                        translatedPhrase.setTranslationIsNeeded();
                        ++this.numberOfUntranslatedString;
                    }
                    translatedPhrase.setTextId(srcTextRecord.getInt("SourceText_ID"));
                    translatedPhrase.setTranslatedTextId(srcTextRecord.getInt("TranslatedText_ID"));
                    translatedPhrase.setKeyId(srcTextRecord.getInt("Label_ID"));
                } else {
                    if (!this.printedFileNameFlag) {
                        System.out.println("*************************************************");
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("File: ").append(this.currentFile.getFilePath()).append(this.currentFile.getFileName()))));
                        this.printedFileNameFlag = true;
                    }
                    System.out.println("    The following was not translated in the preferred install :  ");
                    System.out.println("    Key : ".concat(String.valueOf(String.valueOf(sourcePhrase.getKey()))));
                    System.out.println("    Phrase : ".concat(String.valueOf(String.valueOf(sourcePhrase.getText()))));
                    ++this.numberOfNewStrings;
                    this.translateAccordingToAttempt2(sourcePhrase, translatedPhrase);
                    if (translatedPhrase.isEmpty()) {
                        this.translateAccordingToAttempt3(sourcePhrase, translatedPhrase);
                        if (translatedPhrase.isEmpty()) {
                            translatedPhrase.setKey(sourcePhrase.getKey());
                            translatedPhrase.setText(sourcePhrase.getText());
                            translatedPhrase.setTranslation(sourcePhrase.getText());
                            translatedPhrase.setTranslationIsNeeded();
                            ++this.numberOfUntranslatedString;
                            System.out.println("    No translation anywhere found in the database ");
                            System.out.println("");
                        } else {
                            ++this.numberOfStringsTranslatedOnIdenticalText;
                            System.out.println("    Translated after finding identical source text : ".concat(String.valueOf(String.valueOf(translatedPhrase.getTranslatedText()))));
                            System.out.println("");
                        }
                    } else {
                        ++this.numberOfStringsTranslatedInOtherInstalls;
                        System.out.println("    Translated in a different archive to : ".concat(String.valueOf(String.valueOf(translatedPhrase.getTranslatedText()))));
                        System.out.println("");
                    }
                }
            }
            if (this.logTranslationToDB) {
                this.translationsDBWriter.setTargetLanguageCode(this.srcLangCode);
                this.translationsDBWriter.exportPhrase(translatedPhrase);
                this.translationsDBWriter.setTargetLanguageCode(this.trgtLangCode);
                this.translationsDBWriter.exportPhrase(translatedPhrase);
            }
        }
        catch (Exception e) {
            System.out.println("Database exception: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
            System.out.println("strSQL:".concat(String.valueOf(String.valueOf(strSQL))));
            System.exit(1);
        }
    }

    private void translateAccordingToAttempt2(Phrase sourcePhrase, Phrase translatedPhrase) {
        block3: {
            String strSQL = "";
            try {
                this.prepAttempt2.setString(1, this.currentFile.getFileName());
                this.prepAttempt2.setString(2, this.currentFile.getFilePath());
                this.prepAttempt2.setString(3, sourcePhrase.getKey());
                String textString = this.replaceQuote(sourcePhrase.getText());
                this.prepAttempt2.setString(4, textString);
                this.prepAttempt2.setString(5, this.trgtLangCode);
                ResultSet srcTextRecord = this.prepAttempt2.executeQuery();
                if (srcTextRecord.next()) {
                    translatedPhrase.setKey(sourcePhrase.getKey());
                    translatedPhrase.setText(sourcePhrase.getText());
                    String enc_textString = srcTextRecord.getString("TranslatedString");
                    translatedPhrase.setTranslation(enc_textString);
                    translatedPhrase.setTextId(srcTextRecord.getInt("SourceText_ID"));
                    translatedPhrase.setTranslatedTextId(srcTextRecord.getInt("TranslatedText_ID"));
                    translatedPhrase.setKeyId(srcTextRecord.getInt("Label_ID"));
                    translatedPhrase.setTranslationQuality(l10nZilla.ATTEMPT_2_TRANSLATION_QUALITYID, "Attempt 2 Match");
                    break block3;
                }
                translatedPhrase.makeEmpty();
            }
            catch (Exception e) {
                System.out.println("Database exception: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
                System.out.println("strSQL:".concat(String.valueOf(String.valueOf(strSQL))));
                System.exit(1);
            }
        }
    }

    private void translateAccordingToAttempt3(Phrase sourcePhrase, Phrase translatedPhrase) {
        block4: {
            String strSQL = "";
            try {
                if (sourcePhrase.getKey().endsWith("accesskey") || sourcePhrase.getKey().endsWith("accessKey") || sourcePhrase.getKey().endsWith("aKey") || sourcePhrase.getKey().endsWith("Key") || sourcePhrase.getKey().endsWith("key") || sourcePhrase.getKey().endsWith("akey")) {
                    System.out.println("**Access Key Ignored During third attempt translation**");
                    System.out.println(sourcePhrase.getKey());
                    translatedPhrase.makeEmpty();
                    ++this.numberOfIgnoredAcessKeys;
                    break block4;
                }
                String textString = this.replaceQuote(sourcePhrase.getText());
                this.prepAttempt3.setString(1, textString);
                this.prepAttempt3.setString(2, this.trgtLangCode);
                ResultSet srcTextRecord = this.prepAttempt3.executeQuery();
                if (srcTextRecord.next()) {
                    translatedPhrase.setKey(sourcePhrase.getKey());
                    translatedPhrase.setText(sourcePhrase.getText());
                    String enc_textString = srcTextRecord.getString("TranslatedString");
                    translatedPhrase.setTextId(srcTextRecord.getInt("SourceText_ID"));
                    translatedPhrase.setTranslatedTextId(srcTextRecord.getInt("TranslatedText_ID"));
                    translatedPhrase.setKeyId(srcTextRecord.getInt("Label_ID"));
                    translatedPhrase.setTranslation(enc_textString);
                    translatedPhrase.setTranslationQuality(l10nZilla.ATTEMPT_3_TRANSLATION_QUALITYID, "Attempt 3 Match");
                    break block4;
                }
                translatedPhrase.makeEmpty();
            }
            catch (Exception e) {
                System.out.println("Database exception: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
                System.out.println("strSQL:".concat(String.valueOf(String.valueOf(strSQL))));
                System.exit(1);
            }
        }
    }

    public void setTranslatedFile(TranslationFile file) {
        this.currentFile = file;
        this.printedFileNameFlag = false;
        if (this.logTranslationToDB) {
            this.translationsDBWriter.exportFile(file);
        }
    }

    public void setPreferredInstall(String install) {
        boolean installId = false;
        Statement stmt = null;
        ResultSet rs = null;
        String strSQL = String.valueOf(String.valueOf(new StringBuffer("select Install_ID from Installs where Install_Name='").append(install).append("'")));
        try {
            stmt = this.dbConn.createStatement();
            rs = stmt.executeQuery(strSQL);
            if (rs.next()) {
                this.preferredInstallId = rs.getInt("Install_ID");
                this.createTemporaryInstallsTranslationsTable();
            } else {
                System.out.println("Preferred Install Not Recognised!");
            }
        }
        catch (Exception e) {
            System.out.println("Problem with retrieving the install id from the preferredInstall");
            System.out.println(strSQL);
            System.exit(0);
        }
    }

    public void logTranslationsToDB(String install, String destDBURL, String destinationLanguageCode) {
        this.logTranslationToDB = true;
        this.translationsDBWriter = new mozDBWriter(install, destDBURL);
        this.translationsDBWriter.setTargetLanguageCode(destinationLanguageCode);
    }

    private String replaceQuote(String someText) {
        String resultText = "";
        for (int i = 0; i < someText.length(); ++i) {
            String ch = someText.substring(i, i + 1);
            resultText = ch.equalsIgnoreCase("'") ? String.valueOf(String.valueOf(resultText)).concat("'") : String.valueOf(String.valueOf(resultText)).concat(String.valueOf(String.valueOf(ch)));
        }
        return resultText;
    }

    public void report() {
        System.out.println("");
        System.out.println("");
        System.out.println("Summary Of L10NZilla translate operation");
        System.out.println("----------------------------------------------------------");
        System.out.println("");
        System.out.println("Number of source texts found : ".concat(String.valueOf(String.valueOf(this.numberOfStrings))));
        System.out.println("Number of ignored command keys :".concat(String.valueOf(String.valueOf(this.numberOfIgnoredCommandKeys))));
        System.out.println("Number of failed access keys translations ".concat(String.valueOf(String.valueOf(this.numberOfIgnoredAcessKeys))));
        System.out.println("Number translated in preferred archive: ".concat(String.valueOf(String.valueOf(this.numberOfSuccessfulTranslatedStrings))));
        System.out.println("\nNumber Of Untranslated Texts: ".concat(String.valueOf(String.valueOf(this.numberOfNewStrings))));
        System.out.println("\nOf which - ");
        System.out.println("Number of texts translated according from other archives : ".concat(String.valueOf(String.valueOf(this.numberOfStringsTranslatedInOtherInstalls))));
        System.out.println("Number of texts translated according to identical source text : ".concat(String.valueOf(String.valueOf(this.numberOfStringsTranslatedOnIdenticalText))));
        System.out.println("");
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Leaving possibly ").append(this.numberOfUntranslatedString).append(" strings to translate by hand"))));
        System.out.println("");
        System.out.println("");
    }

    private void createTemporaryInstallsTranslationsTable() {
        String strSQL = "";
        try {
            this.stmt = this.dbConn.createStatement();
            strSQL = "DROP TABLE IF EXISTS Temp_Installs_Translations";
            this.stmt.execute(strSQL);
            strSQL = "CREATE TEMPORARY TABLE Temp_Installs_Translations ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("(RowId bigint(20) NOT NULL AUTO_INCREMENT,");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" PRIMARY KEY (RowId), KEY(Label_ID)) ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" TYPE=MyISAM ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("select l.Label_ID, l.Label_Name, f.File_Name, f.File_Location, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" s.SourceText_ID, s.SourceString, t.TranslatedText_ID, t.TranslatedString, t.Quality_ID ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" from TranslatedTexts as t, SourceTexts as s, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" Installs_Labels_Source as ils, Installs_Labels_Source_Target as ilst, Labels as l, Files as f ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" where ilst.Install_ID=").append(this.preferredInstallId)));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and f.File_ID=l.File_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and l.Label_ID=ils.Label_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ils.Label_ID=ilst.Label_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and s.SourceText_ID=ils.SourceText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ils.SourceText_ID=ilst.SourceText_ID");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ilst.TranslatedText_ID=t.TranslatedText_ID");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and ilst.Lang_ID='").append(this.trgtLangCode).append("'")));
            this.stmt.execute(strSQL);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    private boolean isPhraseReallyTranslated(Phrase phrase) {
        boolean isTranslated = true;
        if (phrase.getText().equalsIgnoreCase(phrase.getTranslatedText()) && phrase.getText().length() > 1) {
            isTranslated = false;
        }
        return isTranslated;
    }

    public Connection myDBConnection() {
        return this.dbConn;
    }
}

