/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * c:/builds/1813/mozilla/netwerk/mime/public/nsIMIMEInfo.idl
 */

package org.mozilla.interfaces;

public interface nsIMIMEInfo extends nsISupports {

  String NS_IMIMEINFO_IID =
    "{1448b42f-cf0d-466e-9a15-64e876ebe857}";

  /**
     * Gives you an array of file types associated with this type.
     *
     * @return Number of elements in the array.
     * @return Array of extensions.
     */
  nsIUTF8StringEnumerator getFileExtensions();

  /**
     * Set File Extensions. Input is a comma delimited list of extensions.
     */
  void setFileExtensions(String aExtensions);

  /**
     * Returns whether or not the given extension is
     * associated with this MIME info.
     *
     * @return TRUE if the association exists. 
     */
  boolean extensionExists(String aExtension);

  /**
     * Append a given extension to the set of extensions
     */
  void appendExtension(String aExtension);

  /**
     * Returns the first extension association in
     * the internal set of extensions.
     *
     * @return The first extension.
     */
  String getPrimaryExtension();

  /**
     * Returns the first extension association in
     * the internal set of extensions.
     *
     * @return The first extension.
     */
  void setPrimaryExtension(String aPrimaryExtension);

  /**
     * The MIME type of this MIMEInfo.
     * 
     * @return String representing the MIME type.
     */
  String getMIMEType();

  /**
     * A human readable description of the MIME info.
     *
     * @return The description
     */
  String getDescription();

  /**
     * A human readable description of the MIME info.
     *
     * @return The description
     */
  void setDescription(String aDescription);

  /**
     * Mac Type and creator types
     */
  long getMacType();

  /**
     * Mac Type and creator types
     */
  void setMacType(long aMacType);

  long getMacCreator();

  void setMacCreator(long aMacCreator);

  /**
     * Returns whether or not these two MIME infos are logically
     * equivalent maintaining the one-to-many relationship between
     * MIME types and file extensions.
     *
     * @returns TRUE if the two are considered equal
     */
  boolean _equals(nsIMIMEInfo aMIMEInfo);

  /**
     * Returns a nsIFile that points to the application the user has said
     * they want associated with this content type. This is not always
     * guaranteed to be set!!
     */
  nsIFile getPreferredApplicationHandler();

  /**
     * Returns a nsIFile that points to the application the user has said
     * they want associated with this content type. This is not always
     * guaranteed to be set!!
     */
  void setPreferredApplicationHandler(nsIFile aPreferredApplicationHandler);

  /**
     * A pretty name description of the preferred application.
     */
  String getApplicationDescription();

  /**
     * A pretty name description of the preferred application.
     */
  void setApplicationDescription(String aApplicationDescription);

  /**
     * Indicates whether a default application handler exists,
     * i.e. whether launchWithFile with action = useSystemDefault is possible
     * and applicationDescription will contain usable information.
     */
  boolean getHasDefaultHandler();

  /**
     * A pretty name description of the associated default application. Only
     * usable if hasDefaultHandler is true.
     */
  String getDefaultDescription();

  /**
     * Launches the application with the specified file, in a way that
     * depends on the value of preferredAction. preferredAction must be
     * useHelperApp or useSystemDefault.
     *
     * @param aFile The file to launch this application with.
     *
     * @throw NS_ERROR_INVALID_ARG if action is not valid for this function.
     * Other exceptions may be thrown.
     */
  void launchWithFile(nsIFile aFile);

  int saveToDisk = 0;

  int alwaysAsk = 1;

  int useHelperApp = 2;

  int handleInternally = 3;

  int useSystemDefault = 4;

  /**
     * preferredAction is how the user specified they would like to handle
     * this content type: save to disk, use specified helper app, use OS
     * default handler or handle using navigator.
     */
  int getPreferredAction();

  /**
     * preferredAction is how the user specified they would like to handle
     * this content type: save to disk, use specified helper app, use OS
     * default handler or handle using navigator.
     */
  void setPreferredAction(int aPreferredAction);

  /**
     * alwaysAskBeforeHandling: if true, we should always give the user a
     * dialog asking how to dispose of this content.
     */
  boolean getAlwaysAskBeforeHandling();

  /**
     * alwaysAskBeforeHandling: if true, we should always give the user a
     * dialog asking how to dispose of this content.
     */
  void setAlwaysAskBeforeHandling(boolean aAlwaysAskBeforeHandling);

}