/****************************************************************************
**  DerTandemBrowser - Synchronized browsing add-on for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  This file is part of DerTandemBrowser.
**
**  DerTandemBrowser is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  DerTandemBrowser is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
****************************************************************************/ 

const gEmoticonPaths =
{ 
  ":)" : "chrome://dertandembrowser/content/smile.gif",
  ";)" : "chrome://dertandembrowser/content/wink.gif",
  ":(" : "chrome://dertandembrowser/content/frown.gif",
  ";(" : "chrome://dertandembrowser/content/jacko.gif"
};


const gSoniconInfo =
{ 
  "$*" : {value: "doh!", audio: "chrome://dertandembrowser/content/soniconDoh.wav"},
  "$~" : {value: "splash", audio: "chrome://dertandembrowser/content/soniconSplash.wav"}
};


function makeAction(action_str, container)
{
  var span, text_node;

  span = document.createElementNS("http://www.w3.org/1999/xhtml", "html:span");
  span.setAttribute("style", "color: green; font-style: italic");

  action_str = action_str.replace(/^\/(\w+):/, "$1");

  text_node = document.createTextNode(action_str);
  span.appendChild(text_node);
  container.appendChild(span);
}


function makeEmoticon(emoticon_str, container)
{
  var imgEl;

  imgEL = document.createElementNS("http://www.w3.org/1999/xhtml", "html:img");
  imgEL.setAttribute("src", gEmoticonPaths[emoticon_str]);
  container.appendChild(imgEL);
}


function makeLink(link_str, container)
{
  var anchor, text_node, proto_match_arr;

  proto_match_arr = link_str.match (/^(\w[\w-]+):/);

  if (proto_match_arr)
    href = link_str;
  else
    href = "http://" + link_str;

  anchor = document.createElementNS ("http://www.w3.org/1999/xhtml", "html:a");
  anchor.setAttribute ("href", href);
  anchor.setAttribute ("target", "_content");
  anchor.setAttribute ("style", "color: blue");
  text_node = document.createTextNode(link_str);
  anchor.appendChild(text_node);
  container.appendChild (anchor);
}


function makeEmphasis(emphasis_str, container)
{
  var span, text_node;

  span = document.createElementNS("http://www.w3.org/1999/xhtml", "html:span");
  span.setAttribute("style", "font-weight: bold");

  emphasis_str = emphasis_str.replace(/\s\*([\w']+)(?:\*\s|\*$)/, " $1 ");

  text_node = document.createTextNode(emphasis_str);
  span.appendChild(text_node);
  container.appendChild(span);
}


function makeSonicon(sonicon_str, container)
{
  var imgEl, span, text_node;

  imgEL = document.createElementNS("http://www.w3.org/1999/xhtml", "html:img");
  imgEL.setAttribute("src", "chrome://dertandembrowser/content/ear.gif");
  container.appendChild(imgEL);

  span = document.createElementNS("http://www.w3.org/1999/xhtml", "html:span");
  span.setAttribute("style", "color: purple; font-style: italic");

  text_node = document.createTextNode(" " + gSoniconInfo[sonicon_str].value);
  span.appendChild(text_node);
  container.appendChild(span);

  playSoundFile(gSoniconInfo[sonicon_str].audio);
}


dtbChatWidgets = 
{
  actions:
   {
     enabled: function() { return true;}, 
     rule:    /^\/\w+:[\w\W]*/,
     maker:   makeAction
   },
  emoticons:
   {
     enabled: function() { return getDTBUserPreferenceValue("show_emoticons");}, 
     rule:    /[:;][()]/,
     maker:   makeEmoticon
   },
  links:
   {
     enabled: function() { return true;}, 
     rule:    /((\w[\w-]+):[^<>\[\]()\'\"\s\u201d]+|www(\.[^.<>\[\]()\'\"\s\u201d]+){2,})/,
     maker:   makeLink
   },
  emphasis:
   {
     enabled: function() { return true;}, 
     rule:    /\s\*[\w']+(?:\*\s|\*$)/,
     maker:   makeEmphasis
   },
  sonicons:
   {
     enabled: function() { return getDTBUserPreferenceValue("play_sonicons");}, 
     rule:    /\$[*~]/,
     maker:   makeSonicon
   },

}


function parseForChatWidgets(text_str, container)
{
  var text_node, match_arr;


  for (var i in dtbChatWidgets)
   {
     if (dtbChatWidgets[i].enabled() == true)
      {
        match_arr = text_str.match(dtbChatWidgets[i].rule);

        if (match_arr)
         {
           parseForChatWidgets(text_str.substring(0, match_arr.index), container);
           dtbChatWidgets[i].maker(match_arr[0], container);
           parseForChatWidgets(text_str.substring(match_arr.index+match_arr[0].length),
                               container);
           break;
         }
      }
   }

  if (!match_arr)
   {
     text_node = document.createTextNode(text_str);
     container.appendChild(text_node);    
   }
}
           
  
