/*
<!-- 
****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky.

The Initial Developer of the Original Code is
Joachim Schreiber (yobiz@users.sourceforge.net).
Portions created by the Initial Developer are Copyright (C) 2002-2004
the Initial Developer. All Rights Reserved.

Contributor(s):
Mike Hommey (mh@glandium.org)

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

Checky - Resource Validation and Analysis Extension for Mozilla and Firefox.
Easy to use Interface to many different free and commercial Online 
Validation and Analysis Services. Any rights not expressly granted herein 
are reserved by their owners. 
Please visit all Service Web Sites for more informations about terms of usage 
before using Checky the first time. Hyperlinks are located at 
http://checky.sourceforge.net/#Services

***** END LICENSE BLOCK *****
-->

*/


netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");


var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
var pref = prefService.getBranch(null); // preferences root node
var IsFireBird = Components.classes['@mozilla.org/commandlinehandler/general-startup;1?type=browser'].getService(Components.interfaces.nsICmdLineHandler).chromeUrlForTask.match(/^chrome:\/\/browser\//) ? true : false;

const prefTimeout = "ext.checky.pref.global.timeout";
const prefAppearance = "ext.checky.pref.global.appearance";
const prefLocalUris = "ext.checky.pref.global.localurls";
const prefTempDirectory = "ext.checky.pref.global.tempdirectory";


const extCheckyAboutMozdev = "http://checky.mozdev.org/";
const extCheckyAboutSourceForge = "http://checky.sourceforge.net/";
const extCheckyAboutFreshmeat = "http://freshmeat.net/projects/checky/";
const extCheckyAboutServices = "http://checky.sourceforge.net/#Services";
const extCheckyAboutBugs = "http://sourceforge.net/tracker/?group_id=69729&atid=532492";



/******************************************************************************
	[w3c.html]  - W3C HTML MarkUp Validation Service
******************************************************************************/
const W3cHtmlUrl = "http://validator.w3.org/detailed.html";
const W3cHtmlUpload = "http://validator.w3.org/file-upload.html";	

function checkyW3CHtml(serviceWindow, uri, appearance, upload){

	var charsetPref = pref.getIntPref("ext.checky.w3c.html.url.charset");
	var doctypePref = pref.getIntPref("ext.checky.w3c.html.url.doctype"); 

	var fallbackencPref = pref.getBoolPref("ext.checky.w3c.html.url.options.fallbackenc");
	var fallbackdocPref = pref.getBoolPref("ext.checky.w3c.html.url.options.fallbackdoc");

	var ssPref = pref.getBoolPref("ext.checky.w3c.html.url.options.ss");
	var spPref = pref.getBoolPref("ext.checky.w3c.html.url.options.sp");
	var outlinePref = pref.getBoolPref("ext.checky.w3c.html.url.options.outline");
	var noattPref = pref.getBoolPref("ext.checky.w3c.html.url.options.noatt");
	var No200Pref = pref.getBoolPref("ext.checky.w3c.html.url.options.No200");
	var verbosePref = pref.getBoolPref("ext.checky.w3c.html.url.options.verbose");

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}


	if(upload){
		myDocument.getElementById("uploaded_file").value=uri;
	}
	else{
		myDocument.getElementById("uri").value=uri;
	}
	myDocument.getElementById("charset").selectedIndex=charsetPref;
	myDocument.getElementById("doctype").selectedIndex=doctypePref;

	if(fallbackencPref){
		myDocument.forms[0].fbc.checked = true;
	}
	else{
		myDocument.forms[0].fbc.checked = false;
	}

	if(fallbackdocPref){
		myDocument.forms[0].fbd.checked = true;
	}
	else{
		myDocument.forms[0].fbd.checked = false;
	}


	if(ssPref){
		myDocument.forms[0].ss.checked = true;
	}
	else{
		myDocument.forms[0].ss.checked = false;
	}

	if(spPref){
		myDocument.forms[0].sp.checked = true;
	}
	else{
		myDocument.forms[0].sp.checked = false;
	}
	
	if(outlinePref){
		myDocument.forms[0].outline.checked = true;
	}
	else{
		myDocument.forms[0].outline.checked = false;
	}
	
	if(noattPref){
		myDocument.forms[0].noatt.checked = true;
	}
	else{
		myDocument.forms[0].noatt.checked = false;
	}
	
	if(No200Pref){
		myDocument.forms[0].No200.checked = true;
	}
	else{
		myDocument.forms[0].No200.checked = false;
	}
	
	if(verbosePref){
		myDocument.forms[0].verbose.checked = true;
	}
	else{
		//disable default html form 
		myDocument.forms[0].verbose.checked = false;
	}

	myDocument.forms[0].submit();

}

/******************************************************************************
	[w3c.css]  - W3C CSS Validaton Service
******************************************************************************/
const W3cCssUrl = "http://jigsaw.w3.org/css-validator/validator-uri.html";
const W3cCssUpload = "http://jigsaw.w3.org/css-validator/validator-upload.html";	

function checkyW3CCss(serviceWindow, uri, appearance, upload){

	var warningPref = pref.getIntPref("ext.checky.w3c.css.url.warning");
	var profilePref = pref.getIntPref("ext.checky.w3c.css.url.profile");
	var usermediumPref = pref.getIntPref("ext.checky.w3c.css.url.usermedium");

	var warningUploadPref = pref.getIntPref("ext.checky.w3c.css.upload.warning");
	var profileUploadPref = pref.getIntPref("ext.checky.w3c.css.upload.profile");
	var usermediumUploadPref = pref.getIntPref("ext.checky.w3c.css.upload.usermedium");

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	if(upload){
		myDocument.forms[0].file.value=uri;

		if(warningUploadPref){
			myDocument.forms[0].warning.selectedIndex=warningUploadPref;
		}
		else{
			myDocument.forms[0].warning.selectedIndex = 1;
		}

		if(profileUploadPref){
			myDocument.forms[0].profile.selectedIndex=profileUploadPref;
		}
		else{
			myDocument.forms[0].profile.selectedIndex= 2;
		}

		if(usermediumUploadPref){
			myDocument.forms[0].usermedium.selectedIndex=usermediumUploadPref;
		}
		else{
			myDocument.forms[0].usermedium.selectedIndex= 0;
		}

	}
	else{
		myDocument.forms[0].uri.value=uri;

		if(warningPref){
			myDocument.forms[0].warning.selectedIndex=warningPref;
		}
		else{
			myDocument.forms[0].warning.selectedIndex = 1;
		}

		if(profilePref){
			myDocument.forms[0].profile.selectedIndex=profilePref;
		}
		else{
			myDocument.forms[0].profile.selectedIndex= 2;
		}

		if(usermediumPref){
			myDocument.forms[0].usermedium.selectedIndex=profilePref;
		}
		else{
			myDocument.forms[0].usermedium.selectedIndex= 0;
		}

	}

	myDocument.forms[0].submit();
}


/******************************************************************************
	[wdg.html]  - WDG HTML Validaton Service
******************************************************************************/
const WdgHtmlUrl = "http://www.htmlhelp.com/tools/validator/";
const WdgHtmlUpload = "http://www.htmlhelp.com/tools/validator/upload.html";	

function checkyWdgHtml(serviceWindow, uri, appearance, upload){

	var warnings = pref.getBoolPref("ext.checky.wdg.html.url.options.warnings");
	var input = pref.getBoolPref("ext.checky.wdg.html.url.options.input");
	var spider = pref.getBoolPref("ext.checky.wdg.html.url.options.spider");
	var hidevalid = pref.getBoolPref("ext.checky.wdg.html.url.options.hidevalid");

	var charsetUpload = pref.getIntPref("ext.checky.wdg.html.upload.charset");
	var warningsUpload = pref.getBoolPref("ext.checky.wdg.html.upload.options.warnings");
	var inputUpload = pref.getBoolPref("ext.checky.wdg.html.upload.options.input");

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	if(upload){
		myDocument.forms[0].file.value=uri;

		if(charsetUpload){
			myDocument.forms[0].charset.selectedIndex=charsetUpload;
		}
		else{
			myDocument.forms[0].charset.selectedIndex = 0;
		}

		if(warningsUpload){
			myDocument.forms[0].warnings.checked = true;
		}
		else{
			myDocument.forms[0].warnings.checked = false;
		}

		if(inputUpload){
			myDocument.forms[0].input.checked = true;
		}
		else{
			myDocument.forms[0].input.checked = false;
		}

	}
	else{
		myDocument.forms[0].url.value=uri;

		if(warnings){
			myDocument.forms[0].warnings.checked = true;
		}
		else{
			myDocument.forms[0].warnings.checked = false;
		}

		if(input){
			myDocument.forms[0].input.checked = true;
		}
		else{
			myDocument.forms[0].input.checked = false;
		}

		if(spider){
			myDocument.forms[0].spider.checked = true;
		}
		else{
			myDocument.forms[0].spider.checked = false;
		}

		if(hidevalid){
			myDocument.forms[0].hidevalid.checked = true;
		}
		else{
			myDocument.forms[0].hidevalid.checked = false;
		}


	}

	myDocument.forms[0].submit();
}

/******************************************************************************
	[wdg.css]  - WDG CSS Validaton Service
******************************************************************************/
const WdgCssUrl = "http://www.htmlhelp.com/tools/csscheck/";
const WdgCssUpload = "http://www.htmlhelp.com/tools/csscheck/upload.html";	

function checkyWdgCss(serviceWindow, uri, appearance, upload){

	var warnings = pref.getBoolPref("ext.checky.wdg.css.url.options.warnings");
	var input = pref.getBoolPref("ext.checky.wdg.css.url.options.input");

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	if(upload){
		myDocument.forms[0].cssfile.value=uri;

		if(warnings){
			myDocument.forms[0].warnings.checked = true;
		}
		else{
			myDocument.forms[0].warnings.checked = false;
		}

		if(input){
			myDocument.forms[0].input.checked = true;
		}
		else{
			myDocument.forms[0].input.checked = false;
		}

	}
	else{
		myDocument.forms[0].url.value=uri;

		if(warnings){
			myDocument.forms[0].warnings.checked = true;
		}
		else{
			myDocument.forms[0].warnings.checked = false;
		}

		if(input){
			myDocument.forms[0].input.checked = true;
		}
		else{
			myDocument.forms[0].input.checked = false;
		}

	}

	myDocument.forms[0].submit();
}


/******************************************************************************
	[w3c.rdf]  - W3C RDF Validation Service
******************************************************************************/
const W3cRdfUrl = "http://www.w3.org/RDF/Validator/";

function checkyW3CRdf(serviceWindow, uri, appearance, upload){

	var TRIPLES_AND_GRAPH = pref.getIntPref("ext.checky.w3c.rdf.url.options.TRIPLES_AND_GRAPH");
	var SAVE_DOT_FILE = pref.getBoolPref("ext.checky.w3c.rdf.url.options.SAVE_DOT_FILE");
	var NTRIPLES = pref.getBoolPref("ext.checky.w3c.rdf.url.options.NTRIPLES");
	var EMBEDDED_RDF = pref.getBoolPref("ext.checky.w3c.rdf.url.options.EMBEDDED_RDF");
	var SAVE_RDF = pref.getBoolPref("ext.checky.w3c.rdf.url.options.SAVE_RDF");
	var ANON_NODES_EMPTY = pref.getBoolPref("ext.checky.w3c.rdf.url.options.ANON_NODES_EMPTY");
	var nodes = pref.getIntPref("ext.checky.w3c.rdf.colours.nodes");
	var nodetext = pref.getIntPref("ext.checky.w3c.rdf.colours.nodetext");
	var arcs = pref.getIntPref("ext.checky.w3c.rdf.colours.arcs");
	var arctext = pref.getIntPref("ext.checky.w3c.rdf.colours.arctext");
	var fontsize = pref.getIntPref("ext.checky.w3c.rdf.graph.fontsize");
	var orientation = pref.getIntPref("ext.checky.w3c.rdf.graph.orientation");
	var format = pref.getIntPref("ext.checky.w3c.rdf.graph.format");


	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].URI.value= uri;

	myDocument.forms[0].TRIPLES_AND_GRAPH.selectedIndex = TRIPLES_AND_GRAPH;

	myDocument.forms[0].NODE_COLOR.selectedIndex = nodes;
	myDocument.forms[0].NODE_TEXT_COLOR.selectedIndex = nodetext;
	myDocument.forms[0].EDGE_COLOR.selectedIndex = arcs;
	myDocument.forms[0].EDGE_TEXT_COLOR.selectedIndex = arctext;
	myDocument.forms[0].FONT_SIZE.selectedIndex = fontsize;
	myDocument.forms[0].ORIENTATION.selectedIndex = orientation;
	myDocument.forms[0].FORMAT.selectedIndex = format;


	if(SAVE_DOT_FILE){
		myDocument.forms[0].SAVE_DOT_FILE.checked = true;
	}
	else{
		myDocument.forms[0].SAVE_DOT_FILE.checked = false;
	}

	if(NTRIPLES){
		myDocument.forms[0].NTRIPLES.checked = true;
	}
	else{
		myDocument.forms[0].NTRIPLES.checked = false;
	}

	if(EMBEDDED_RDF){
		myDocument.forms[0].EMBEDDED_RDF.checked = true;
	}
	else{
		myDocument.forms[0].EMBEDDED_RDF.checked = false;
	}

	if(SAVE_RDF){
		myDocument.forms[0].SAVE_RDF.checked = true;
	}
	else{
		myDocument.forms[0].SAVE_RDF.checked = false;
	}

	if(ANON_NODES_EMPTY){
		myDocument.forms[0].ANON_NODES_EMPTY.checked = true;
	}
	else{
		myDocument.forms[0].ANON_NODES_EMPTY.checked = false;
	}

	myDocument.forms[0].submit();

}



/******************************************************************************
	[w3c.link]  - W3C link Validation Service
******************************************************************************/
const W3cLinkUrl = "http://validator.w3.org/checklink";

function checkyW3CLink(serviceWindow, uri, appearance, upload){

	var hide_type = pref.getIntPref("ext.checky.w3c.link.url.options.hide_type");
	var depth = pref.getCharPref("ext.checky.w3c.link.url.options.depth");
	var summary = pref.getBoolPref("ext.checky.w3c.link.url.options.summary");
	var hide_redirects = pref.getBoolPref("ext.checky.w3c.link.url.options.hide_redirects");
	var no_accept_language = pref.getBoolPref("ext.checky.w3c.link.url.options.no_accept_language");
	var recursive = pref.getBoolPref("ext.checky.w3c.link.url.options.recursive");
	var cookie = pref.getBoolPref("ext.checky.w3c.link.url.options.cookie");

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].uri.value= uri;

	myDocument.forms[0].depth.value = depth;

	myDocument.forms[0].hide_type[hide_type].checked = true;

	if(summary){
		myDocument.forms[0].summary.checked = true;
	}
	else{
		myDocument.forms[0].summary.checked = false;
	}

	if(hide_redirects){
		myDocument.forms[0].hide_redirects.checked = true;
	}
	else{
		myDocument.forms[0].hide_redirects.checked = false;
	}

	if(no_accept_language){
		myDocument.forms[0].no_accept_language.checked = true;
	}
	else{
		myDocument.forms[0].no_accept_language.checked = false;
	}

	if(recursive){
		myDocument.forms[0].recursive.checked = true;
	}
	else{
		myDocument.forms[0].recursive.checked = false;
	}

	if(cookie){
		myDocument.forms[0].cookie.checked = true;
	}
	else{
		myDocument.forms[0].cookie.checked = false;
	}

	myDocument.forms[0].submit();

}



/******************************************************************************
	[w3c.tidy]  - W3C HTML TIDY
******************************************************************************/
const W3cTidyUrl = "http://cgi.w3.org/cgi-bin/tidy";

function checkyW3CTidy(serviceWindow, uri, appearance, upload){

	var indent = pref.getBoolPref("ext.checky.w3c.tidy.options.indent");

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].docAddr.value= uri;

	if(indent){
		myDocument.forms[0].indent.checked = true;
	}
	else{
		myDocument.forms[0].indent.checked = false;
	}
	myDocument.forms[0].submit();

}


/******************************************************************************
	[w3c.table]  - W3C Table
******************************************************************************/
const W3cTableUrl = "http://www.w3.org/WAI/References/Tablin/form";

function checkyW3CTable(serviceWindow, uri, appearance, upload){

	var cellSeparator = pref.getCharPref("ext.checky.w3c.table.cellSeparator");
	var tableno = pref.getCharPref("ext.checky.w3c.table.tableno");
	var headerSeparator = pref.getCharPref("ext.checky.w3c.table.headerSeparator");
	var valueSeparator = pref.getCharPref("ext.checky.w3c.table.valueSeparator");
	var orient = pref.getIntPref("ext.checky.w3c.table.orient");
	var repeat = pref.getIntPref("ext.checky.w3c.table.repeat"); 
	var interact = pref.getIntPref("ext.checky.w3c.table.interact"); 
	var recurs = pref.getBoolPref("ext.checky.w3c.table.recurs"); 
	var embedded = pref.getBoolPref("ext.checky.w3c.table.embedded"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].cellSeparator.value = cellSeparator;
	myDocument.forms[0].tableno.value = tableno;
	myDocument.forms[0].headerSeparator.value = headerSeparator;
	myDocument.forms[0].valueSeparator.value = valueSeparator;

	myDocument.forms[0].orient[orient].checked = true;
	myDocument.forms[0].repeat[repeat].checked = true;
	myDocument.forms[0].interact[interact].checked = true;


	if(recurs){
		myDocument.forms[0].recurs.checked = true;
	}
	else{
		myDocument.forms[0].recurs.checked = false;
	}

	if(embedded){
		myDocument.forms[0].embedded.checked = true;
	}
	else{
		myDocument.forms[0].embedded.checked = false;
	}

	myDocument.forms[0].elements[1].name="susi";
	myDocument.forms[0].submit();

}


/******************************************************************************
	[wdg.link]  - WDG Link
******************************************************************************/
const WdgLinkUrl = "http://www.htmlhelp.com/tools/valet/";

function checkyWdgLink(serviceWindow, uri, appearance, upload){

	var datePref = pref.getCharPref("ext.checky.wdg.link.options.date");
	var typePref = pref.getIntPref("ext.checky.wdg.link.options.type"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].date.value = datePref;
	myDocument.forms[0].type[typePref].checked = true;

	myDocument.forms[0].submit();

}


/******************************************************************************
	[w3c.p3p.policy]  - W3C Policy File Validation
******************************************************************************/
const W3cP3pPolicyUrl = "http://www.w3.org/P3P/validator.html";
const W3cP3pPolicyUpload = "http://www.w3.org/P3P/validator.html";	

function checkyW3CP3pPolicy(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	if(upload){
		myDocument.forms[2].file.value = uri;
		myDocument.forms[2].submit();
	}
	else{
		myDocument.forms[1].uri.value = uri;
		myDocument.forms[1].submit();
	}
}

/******************************************************************************
	[w3c.p3p.integrated]  - W3C Policy Integrated Validation
******************************************************************************/
const W3cP3pIntegratedUrl = "http://www.w3.org/P3P/validator.html";

function checkyW3CP3pIntegrated(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].uri.value = uri;
	myDocument.forms[0].submit();
}


/******************************************************************************
	[delorie.lynx]  - Delorie Lynx Viewer
******************************************************************************/
const DelorieLynxUrl = "http://www.delorie.com/web/lynxview.html";

function checkyDelorieLynx(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value = uri;
	myDocument.forms[0].submit();
}

/******************************************************************************
	[delorie.http]  - Delorie HTTP Header Viewer
******************************************************************************/
const DelorieHttpUrl = "http://www.delorie.com/web/headers.html";

function checkyDelorieHttp(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value = uri;
	myDocument.forms[0].submit();
}


/******************************************************************************
	[delorie.search]  -  Search Engine Simulator
******************************************************************************/
const DelorieSearchUrl = "http://www.delorie.com/web/ses.cgi";

function checkyDelorieSearch(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value = uri;
	myDocument.forms[0].submit();
}

/******************************************************************************
	[delorie.purifier]  -  Web Page Purifier
******************************************************************************/
const DeloriePurifierUrl = "http://www.delorie.com/web/purify.html";

function checkyDeloriePurifier(serviceWindow, uri, appearance, upload){

	var purity = pref.getIntPref("ext.checky.delorie.purifier.purity");
	var text = pref.getBoolPref("ext.checky.delorie.purifier.text"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value = uri;
	myDocument.forms[0].purity.selectedIndex = purity;
	myDocument.forms[0].text.checked = text;
	myDocument.forms[0].submit();
}

/******************************************************************************
	[delorie.backward]  -  Web Page Backward Compatibility Viewer
******************************************************************************/
const DelorieBackwardUrl = "http://www.delorie.com/web/wpbcv.html";

function checkyDelorieBackward(serviceWindow, uri, appearance, upload){

	var img = pref.getBoolPref("ext.checky.delorie.backward.feature.img"); 
	var img_broken = pref.getBoolPref("ext.checky.delorie.backward.feature.img_broken"); 
	var img_altless = pref.getBoolPref("ext.checky.delorie.backward.feature.img_altless"); 
	var img_sizeless = pref.getBoolPref("ext.checky.delorie.backward.feature.img_sizeless"); 
	var table = pref.getBoolPref("ext.checky.delorie.backward.feature.table"); 
	var table_br = pref.getBoolPref("ext.checky.delorie.backward.feature.table_br"); 
	var blink = pref.getBoolPref("ext.checky.delorie.backward.feature.blink"); 
	var frame = pref.getBoolPref("ext.checky.delorie.backward.feature.frame"); 
	var font = pref.getBoolPref("ext.checky.delorie.backward.feature.font"); 
	var body = pref.getBoolPref("ext.checky.delorie.backward.feature.body"); 
	var center = pref.getBoolPref("ext.checky.delorie.backward.feature.center"); 
	var applet = pref.getBoolPref("ext.checky.delorie.backward.feature.applet"); 
	var script = pref.getBoolPref("ext.checky.delorie.backward.feature.script"); 
	var style = pref.getBoolPref("ext.checky.delorie.backward.feature.style"); 
	var marquee = pref.getBoolPref("ext.checky.delorie.backward.feature.marquee"); 
	var agent = pref.getCharPref("ext.checky.delorie.backward.feature.agent"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value = uri;

	myDocument.forms[0].img.checked = img;
	myDocument.forms[0].img_broken.checked = img_broken;
	myDocument.forms[0].img_altless.checked = img_altless;
	myDocument.forms[0].img_sizeless.checked = img_sizeless;
	myDocument.forms[0].table.checked = table;
	myDocument.forms[0].table_br.checked = table_br;
	myDocument.forms[0].blink.checked = blink;
	myDocument.forms[0].frame.checked = frame;
	myDocument.forms[0].font.checked = font;
	myDocument.forms[0].body.checked = body;
	myDocument.forms[0].center.checked = center;
	myDocument.forms[0].applet.checked = applet;
	myDocument.forms[0].script.checked = script;
	myDocument.forms[0].style.checked = style;
	myDocument.forms[0].marquee.checked = marquee;

	myDocument.forms[0].agent.value = agent;

	myDocument.forms[0].submit();
}


/******************************************************************************
	[webthing.link]  - WebThing Link Valet
******************************************************************************/
const WebThingLinkUrl = "http://valet.webthing.com/link/";

function checkyWebThingLink(serviceWindow, uri, appearance, upload){

	var datePref = pref.getCharPref("ext.checky.webthing.link.options.date");
	var typePref = pref.getIntPref("ext.checky.webthing.link.options.type"); 

	var depth = pref.getIntPref("ext.checky.webthing.link.options.depth"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].date.value = datePref;
	myDocument.forms[0].type[typePref].checked = true;
	myDocument.forms[0].depth[depth].checked = true;

	myDocument.forms[0].submit();

}



/******************************************************************************
	[webthing.page]  - Page Valet
******************************************************************************/
const WebThingPageUrl = "http://valet.webthing.com/page/";

function checkyWebThingPage(serviceWindow, uri, appearance, upload){

	var parser = pref.getIntPref("ext.checky.webthing.page.parser"); 
	var resultsMode = pref.getIntPref("ext.checky.webthing.page.resultsMode"); 
	var parseMode = pref.getIntPref("ext.checky.webthing.page.parseMode"); 
	var Force = pref.getBoolPref("ext.checky.webthing.page.options.Force"); 
	var Schema = pref.getBoolPref("ext.checky.webthing.page.options.Schema"); 
	var Namespace = pref.getBoolPref("ext.checky.webthing.page.options.Namespace"); 


	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].parser.selectedIndex = parser;
	myDocument.forms[0].resultsMode.selectedIndex = resultsMode;
	myDocument.forms[0].parseMode[parseMode].checked = true;

	myDocument.forms[0].Force.checked = Force;
	myDocument.forms[0].Schema.checked = Schema;
	myDocument.forms[0].Namespace.checked = Namespace;

	myDocument.forms[0].submit();

}


/******************************************************************************
	[webthing.accessibility]  - Accessibility Valet
******************************************************************************/
const WebThingAccessibilityUrl = "http://valet.webthing.com/access/url.html";

function checkyWebThingAccessibility(serviceWindow, uri, appearance, upload){

	var suite = pref.getIntPref("ext.checky.webthing.accessibility.suite"); 
	var xslt = pref.getIntPref("ext.checky.webthing.accessibility.xslt"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].suite.selectedIndex = suite;
	myDocument.forms[0].xslt.selectedIndex = xslt;

	myDocument.forms[0].submit();

}

/******************************************************************************
	[watchfire.bobby]  - Watchfire Bobby
******************************************************************************/
const WatchfireBobbyUrl = "http://bobby.watchfire.com/bobby/html/en/advanced.jsp";

function checkyWatchfireBobby(serviceWindow, uri, appearance, upload){

	var gl = pref.getIntPref("ext.checky.watchfire.bobby.gl"); 
	var Text = pref.getBoolPref("ext.checky.watchfire.bobby.options.Text"); 
	var line = pref.getBoolPref("ext.checky.watchfire.bobby.options.line"); 
	var an_errs = pref.getBoolPref("ext.checky.watchfire.bobby.options.an_errs"); 
	var browser = pref.getIntPref("ext.checky.watchfire.bobby.browser"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;


	myDocument.forms[0].gl[gl].checked = true;
	myDocument.forms[0].Text.checked = Text;
	myDocument.forms[0].line.checked = line;
	myDocument.forms[0].an_errs.checked = an_errs;
	myDocument.forms[0].stealth.selectedIndex = browser;
	myDocument.forms[0].submit();

}


/******************************************************************************
	[watchfire.webxact]  - Watchfire Webxact
******************************************************************************/
const WatchfireWebxactUrl = "http://webxact.watchfire.com/";

function checkyWatchfireWebxact(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].SCANURL.value= uri;
	myDocument.forms[0].submit();

}



/******************************************************************************
	[piat.wave]  - PIAT WAVE 3.0 Accessibility Tool 
******************************************************************************/
const PiatWaveUrl = "http://www.wave.webaim.org/index.jsp";
const PiatWaveUpload = "http://www.wave.webaim.org/index.jsp";	

function checkyPiatWave(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	if(upload){
		myDocument.forms[2].upload.value=uri;
		myDocument.forms[2].submit();
	}
	else{
		myDocument.forms[0].uri.value=uri;
		myDocument.forms[0].submit();
	}

}



/******************************************************************************
	[hisoft.cynthia]  - HiSoft Cynthia 
******************************************************************************/
const HisoftCynthiaUrl = "http://www.contentquality.com/fulloptions.asp";

function checkyHisoftCynthia(serviceWindow, uri, appearance, upload){

	var rptmode = pref.getIntPref("ext.checky.hisoft.cynthia.rptmode"); 
	var warnp2n3e = pref.getBoolPref("ext.checky.hisoft.cynthia.options.warnp2n3e"); 
	var runcr = pref.getBoolPref("ext.checky.hisoft.cynthia.options.runcr"); 
	var incsrc = pref.getBoolPref("ext.checky.hisoft.cynthia.options.incsrc"); 
	var runpmcid = pref.getBoolPref("ext.checky.hisoft.cynthia.options.runpmcid"); 
	var runagc = pref.getBoolPref("ext.checky.hisoft.cynthia.options.runagc"); 
	var BROWSE_EMUL = pref.getIntPref("ext.checky.hisoft.cynthia.BROWSE_EMUL"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url1.value= uri;

	myDocument.forms[0].rptmode.selectedIndex = rptmode;
	myDocument.forms[0].warnp2n3e.checked = warnp2n3e;
	myDocument.forms[0].runcr.checked = runcr;
	myDocument.forms[0].incsrc.checked = incsrc;
	myDocument.forms[0].runpmcid.checked = runpmcid;
	myDocument.forms[0].runagc.checked = runagc;
	myDocument.forms[0].BROWSE_EMUL.selectedIndex = BROWSE_EMUL;
	myDocument.forms[0].submit();

}


/******************************************************************************
	[wickline.color]  - Wickline Colorblind Web Page Filter
******************************************************************************/
const WicklineColorUrl = "http://colorfilter.wickline.org/";

function checkyWicklineColor(serviceWindow, uri, appearance, upload){

	var t = pref.getIntPref("ext.checky.wickline.color.t"); 
	var i = pref.getBoolPref("ext.checky.wickline.color.options.i"); 
	var n = pref.getBoolPref("ext.checky.wickline.color.options.n"); 
	var j = pref.getBoolPref("ext.checky.wickline.color.options.j"); 
	var c = pref.getBoolPref("ext.checky.wickline.color.options.c"); 
	var b = pref.getBoolPref("ext.checky.wickline.color.options.b"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].u.value= uri;

	myDocument.forms[0].t.selectedIndex = t;
	myDocument.forms[0].i.checked = i;
	myDocument.forms[0].n.checked = n;
	myDocument.forms[0].j.checked = j;
	myDocument.forms[0].c.checked = c;
	myDocument.forms[0].b.checked = b;
	myDocument.forms[0].submit();

}

/******************************************************************************
	[vischeck.color]  - Vischeck
******************************************************************************/
const VischeckColorUrl = "http://www.vischeck.com/vischeck/vischeckURL.php";

function checkyVischeckColor(serviceWindow, uri, appearance, upload){

	var sensorType = pref.getIntPref("ext.checky.vischeck.color.sensorType"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;
	myDocument.forms[0].sensorType[sensorType].checked = true;

	myDocument.forms[0].submit();

}


/******************************************************************************
	[redland.rss]  - Redland RSS 1.0 Validator and Viewer
******************************************************************************/
const RedlandRssUrl = "http://www.redland.opensource.ac.uk/rss/";

function checkyRedlandRss(serviceWindow, uri, appearance, upload){

	var box = pref.getIntPref("ext.checky.redland.rss.box"); 

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].uri.value= uri;
	myDocument.forms[0].box.selectedIndex = box;

	myDocument.forms[0].submit();

}

/******************************************************************************
	[pilgrim.rss]  - Pilgrim RSS Validator
******************************************************************************/
const PilgrimRssUrl = "http://feeds.archive.org/validator/";

function checkyPilgrimRss(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}

/******************************************************************************
	[userland.rss]  - Userland RSS Validator
******************************************************************************/
const UserlandRssUrl = "http://aggregator.userland.com/validator";

function checkyUserlandRss(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}


/******************************************************************************
	[wso.page]  - WSO Web Page Analyzer 
******************************************************************************/
const WsoPageUrl = "http://www.websiteoptimization.com/services/analyze/";

function checkyWsoPage(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[1].url.value= uri;

	myDocument.forms[1].submit();

}


/******************************************************************************
	[konstantin.clean]  
******************************************************************************/
const KonstantinCleanUrl = "http://yook.de/webmaster/clean/";

function checkyKonstantinClean(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}


/******************************************************************************
	[phd.size]  
******************************************************************************/
const PhdSizeUrl = "http://searchengineworld.com/cgi-bin/page_size.cgi";

function checkyPhdSize(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}



/******************************************************************************
	[phd.robots]  
******************************************************************************/
const PhdRobotsUrl = "http://searchengineworld.com/cgi-bin/robotcheck.cgi";

function checkyPhdRobots(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}



/******************************************************************************
	[phd.header]  
******************************************************************************/
const PhdHeaderUrl = "http://searchengineworld.com/cgi-bin/servercheck.cgi";

function checkyPhdHeader(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}



/******************************************************************************
	[ai.html]  
******************************************************************************/
const AiHtmlUrl = "http://htmlvalidator.com/";

function checkyAiHtml(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}



/******************************************************************************
	[alpine.html]  
******************************************************************************/
const AlpineHtmlUrl = "http://www.alpdev.com/.docs/pg/drhtml.html";

function checkyAlpineHtml(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[1].address.value= uri;

	myDocument.forms[1].submit();

}



/******************************************************************************
	[audit.search]  
******************************************************************************/
const AuditSearchUrl = "http://www.auditit.com/urlcheck/";

function checkyAuditSearch(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].q.value= uri;

	myDocument.forms[0].submit();

}





/******************************************************************************
	[abs.meta]  
******************************************************************************/
const AbsMetaUrl = "http://www.scrubtheweb.com/abs/meta-check.html";

function checkyAbsMeta(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[2].URL.value= uri;

	myDocument.forms[2].submit();

}



/******************************************************************************
	[will.link]  
******************************************************************************/
const WillLinkUrl = "http://www.webmaster-toolkit.com/link-popularity-checker.shtml";

function checkyWillLink(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}





/******************************************************************************
	[northern.meta]  
******************************************************************************/
const NorthernMetaUrl = "http://northernwebs.com/set/spider_view_da.html";

function checkyNorthernMeta(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].url.value= uri;

	myDocument.forms[0].submit();

}




/******************************************************************************
	[oreilly.xml]  
******************************************************************************/
const OreillyXmlUrl = "http://www.xml.com/pub/a/tools/ruwf/check.html";

function checkyOreillyXml(serviceWindow, uri, appearance, upload){

	var myDocument = null;

	if(appearance == 0){
		var aBrowser = gBrowser.getBrowserForTab(serviceWindow);
		myDocument = aBrowser.contentDocument;
	}

	if(appearance == 1){
		myDocument = serviceWindow.document;
	}

	myDocument.forms[0].URL.value= uri;

	myDocument.forms[0].submit();

}


function extCheckyAgent(){

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.html") ){
		extCheckyValidateResource("w3c.html");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.css") ){
		extCheckyValidateResource("w3c.css");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.wdg.html") ){
		extCheckyValidateResource("wdg.html");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.wdg.css") ){
		extCheckyValidateResource("wdg.css");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.rdf") ){
		extCheckyValidateResource("w3c.rdf");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.link") ){
		extCheckyValidateResource("w3c.link");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.tidy") ){
		extCheckyValidateResource("w3c.tidy");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.table") ){
		extCheckyValidateResource("w3c.table");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.wdg.link") ){
		extCheckyValidateResource("wdg.link");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.p3p.policy") ){
		extCheckyValidateResource("w3c.p3p.policy");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.w3c.p3p.integrated") ){
		extCheckyValidateResource("w3c.p3p.integrated");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.delorie.lynx") ){
		extCheckyValidateResource("delorie.lynx");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.delorie.http") ){
		extCheckyValidateResource("delorie.http");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.delorie.search") ){
		extCheckyValidateResource("delorie.search");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.delorie.purifier") ){
		extCheckyValidateResource("delorie.putifier");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.delorie.backward") ){
		extCheckyValidateResource("delorie.backward");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.webthing.link") ){
		extCheckyValidateResource("webthing.link");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.webthing.page") ){
		extCheckyValidateResource("webthing.page");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.webthing.accessibility") ){
		extCheckyValidateResource("webthing.accessibility");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.watchfire.bobby") ){
		extCheckyValidateResource("watchfire.bobby");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.watchfire.webxact") ){
		extCheckyValidateResource("watchfire.webxact");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.piat.wave") ){
		extCheckyValidateResource("piat.wave");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.hisoft.cynthia") ){
		extCheckyValidateResource("hisoft.cynthia");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.wickline.color") ){
		extCheckyValidateResource("wickline.color");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.vischeck.color") ){
		extCheckyValidateResource("vischeck.color");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.redland.rss") ){
		extCheckyValidateResource("redland.rss");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.pilgrim.rss") ){
		extCheckyValidateResource("pilgrim.rss");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.userland.rss") ){
		extCheckyValidateResource("userland.rss");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.wso.page") ){
		extCheckyValidateResource("wso.page");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.konstantin.clean") ){
		extCheckyValidateResource("konstantin.clean");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.phd.size") ){
		extCheckyValidateResource("phd.size");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.phd.robots") ){
		extCheckyValidateResource("phd.robots");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.phd.header") ){
		extCheckyValidateResource("phd.header");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.ai.html") ){
		extCheckyValidateResource("ai.html");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.alpine.html") ){
		extCheckyValidateResource("alpine.html");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.audit.search") ){
		extCheckyValidateResource("audit.search");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.abs.meta") ){
		extCheckyValidateResource("abs.meta");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.will.link") ){
		extCheckyValidateResource("will.link");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.northern.meta") ){
		extCheckyValidateResource("northern.meta");
	}

	if( pref.getBoolPref("ext.checky.pref.agent.oreilly.xml") ){
		extCheckyValidateResource("oreilly.xml");
	}


}

function validate( uriToValidate, service, appearance, timeout, upload ){
	var myUriToValidate = uriToValidate;
	var myService = service;
	var myAppearance = appearance;
	var myTimeout = timeout;
	var myUpload = upload;
	
	var myWindowName = "CheckyWindow";

/*
	alert("validate :: myUriToValidate :: " + myUriToValidate);
	alert("validate :: myService :: " + myService);
	alert("validate :: myAppearance :: " + myAppearance);
	alert("validate :: myTimeout :: " + myTimeout);
	alert("validate :: myUpload :: " + myUpload);
*/	
	var myServiceUrl;
	var myServiceWindow;
	switch(service){
		case "w3c.html" :

			if(myUpload){
				myServiceUrl = W3cHtmlUpload;	
			}
			else{
				myServiceUrl = W3cHtmlUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CHtml, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "wdg.html" :

			if(myUpload){
				myServiceUrl = WdgHtmlUpload;	
			}
			else{
				myServiceUrl = WdgHtmlUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWdgHtml, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.css" :

			if(myUpload){
				myServiceUrl = W3cCssUpload;	
			}
			else{
				myServiceUrl = W3cCssUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CCss, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "wdg.css" :

			if(myUpload){
				myServiceUrl = WdgCssUpload;	
			}
			else{
				myServiceUrl = WdgCssUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWdgCss, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.rdf" :

			myServiceUrl = W3cRdfUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CRdf, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.link" :

			myServiceUrl = W3cLinkUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CLink, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.tidy" :

			myServiceUrl = W3cTidyUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CTidy, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.table" :

			myServiceUrl = W3cTableUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CTable, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "wdg.link" :

			myServiceUrl = WdgLinkUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWdgLink, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.p3p.policy" :

			if(myUpload){
				myServiceUrl = W3cP3pPolicyUpload;	
			}
			else{
				myServiceUrl = W3cP3pPolicyUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CP3pPolicy, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "w3c.p3p.integrated" :

			myServiceUrl = W3cP3pIntegratedUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyW3CP3pIntegrated, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "delorie.lynx" :

			myServiceUrl = DelorieLynxUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyDelorieLynx, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "delorie.http" :

			myServiceUrl = DelorieHttpUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyDelorieHttp, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "delorie.search" :

			myServiceUrl = DelorieSearchUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyDelorieSearch, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "delorie.purifier" :

			myServiceUrl = DeloriePurifierUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyDeloriePurifier, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "delorie.backward" :

			myServiceUrl = DelorieBackwardUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyDelorieBackward, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "webthing.link" :

			myServiceUrl = WebThingLinkUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWebThingLink, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "webthing.page" :

			myServiceUrl = WebThingPageUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWebThingPage, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "webthing.accessibility" :

			myServiceUrl = WebThingAccessibilityUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWebThingAccessibility, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "watchfire.bobby" :

			myServiceUrl = WatchfireBobbyUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWatchfireBobby, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "watchfire.webxact" :

			myServiceUrl = WatchfireWebxactUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWatchfireWebxact, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "piat.wave" :

			if(myUpload){
				myServiceUrl = PiatWaveUpload;	
			}
			else{
				myServiceUrl = PiatWaveUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyPiatWave, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "hisoft.cynthia" :

			if(myUpload){
				myServiceUrl = HisoftCynthiaUpload;	
			}
			else{
				myServiceUrl = HisoftCynthiaUrl;	
			}
			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyHisoftCynthia, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "wickline.color" :

			myServiceUrl = WicklineColorUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWicklineColor, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "vischeck.color" :

			myServiceUrl = VischeckColorUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyVischeckColor, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "redland.rss" :

			myServiceUrl = RedlandRssUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyRedlandRss, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "pilgrim.rss" :

			myServiceUrl = PilgrimRssUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyPilgrimRss, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "userland.rss" :

			myServiceUrl = UserlandRssUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyUserlandRss, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "wso.page" :

			myServiceUrl = WsoPageUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWsoPage, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "konstantin.clean" :

			myServiceUrl = KonstantinCleanUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyKonstantinClean, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "phd.size" :

			myServiceUrl = PhdSizeUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyPhdSize, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "phd.robots" :

			myServiceUrl = PhdRobotsUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyPhdRobots, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "phd.header" :

			myServiceUrl = PhdHeaderUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyPhdHeader, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "ai.html" :

			myServiceUrl = AiHtmlUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyAiHtml, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "alpine.html" :

			myServiceUrl = AlpineHtmlUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyAlpineHtml, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "audit.search" :

			myServiceUrl = AuditSearchUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyAuditSearch, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "abs.meta" :

			myServiceUrl = AbsMetaUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyAbsMeta, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "will.link" :

			myServiceUrl = WillLinkUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyWillLink, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "northern.meta" :

			myServiceUrl = NorthernMetaUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyNorthernMeta, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

		case "oreilly.xml" :

			myServiceUrl = OreillyXmlUrl;	

			if(appearance == 0){
				myServiceWindow = getBrowser().addTab( myServiceUrl );
			}
			else{
				myServiceWindow = window.open( myServiceUrl, myWindowName );
			}
			var intervalIDnumber = setInterval( checkyOreillyXml, myTimeout, myServiceWindow, myUriToValidate, myAppearance, myUpload);
			setInterval(stopInterval, myTimeout, intervalIDnumber);

		break;

	}
}



/*
* Stop Interval if ready 
*/
function stopInterval(intervalIDnumber){
	clearInterval(intervalIDnumber);
}

/*
* Open Checky Services
*/
function extCheckyGoServices(){
	document.commandDispatcher.focusedWindow.open( "http://checky.mozdev.org/Services/" );
}

/*
* Open Checky About resources
*/
function extCheckyAbout( resource ) {

	var url;
	switch(resource){
		case "mozdev" :
			url = extCheckyAboutMozdev;
			break;
		case "sourceforge" :
			url = extCheckyAboutSourceForge;
			break;
		case "freshmeat" :
			url = extCheckyAboutFreshmeat;
			break;
		case "services" :
			url = extCheckyAboutServices;
			break;
		case "bugs" :
			url = extCheckyAboutBugs;
			break;
		case "help" :
			url = extCheckyAboutHelp;
			break;
	}	
	document.commandDispatcher.focusedWindow.open( url );
}


/*
* Check platform mozilla is running on
*/
function getNavigatorPlatform(){
	//return 0 if linux, sunos, mac
	//return 1 if windows
	var navigatorPlatform = navigator.platform;
	var tempRegexp = new RegExp("^win", "i");
	if ( ( tempRegexp.test( navigatorPlatform ) ) == true) {
		return 1;
	}
	else{
		return 0;
	}
}


/*
* Get timeout interval from preferences panel in milliseconds
*/
function getTimeout(){
	return ( pref.getIntPref( prefTimeout ) * 1000) ;
}


/*
* Get validation result appearance, tab or window 
*/
function getAppearanceType(){
	//return 0 if tab
	//return 1 if window
	return pref.getIntPref( prefAppearance );
}


function getLocalUris(){

	var localUris = pref.getCharPref( prefLocalUris );

	var tempRegexp = new RegExp("^http://", "i");

	var localUrisArray = new Array();

	var tempLocalUrisArray = localUris.split(",");

	var index = 0;
	for(i=0;i<tempLocalUrisArray.length; i++){
		if(tempLocalUrisArray[i].length > 0){
			if ((tempRegexp.test( tempLocalUrisArray[i] )) == true) {
				localUrisArray[index] = tempLocalUrisArray[i];
			}
			else{
				localUrisArray[index] = "http://" + tempLocalUrisArray[i];
			}
		}
		index++;
	}
	return localUrisArray;
}

/*
* Get temporary directory where we save files from intranet url's which are not accessible online or as file
*/
/*
function getTempDirectory(){
	return pref.getCharPref( prefTempDirectory );
}
*/

function getTempDirectory(){
          var file = pref.getComplexValue( prefTempDirectory , Components.interfaces.nsILocalFile);
          return file.path;
}
 
 
function getUriType(uri){
	//return -1 not a file and not a url
	//return 0 for file
	//retunr 1 for url
	var type = -1;
	var tempRegexp = new RegExp("^file:", "i");
	if ((tempRegexp.test( uri.toString() )) == true) {
		type = 0;
	}
	else{
		type = 1;
	}
	return type;
}

function getUrlType(url){
	//return -1 not local and not online
	//return 0 if local
	//retunr 1 if online
	var type = -1;
	var localUrisArray = getLocalUris();
	for( i = 0; i < localUrisArray.length; i++ ){
		var tempRegexp = new RegExp("^" + localUrisArray[i] , "i");
		if ((tempRegexp.test(url)) == true) {
			type = 0;
			break;
		}
		else{
			type = 1;
		}
	}
	return type;
}


function getSystemPathSeparator(){
	var winPathSeparator = "\\";
	var unixPathSeparator = "/";
	if( getNavigatorPlatform() == 1 ){
		return winPathSeparator;
	}
	return unixPathSeparator;
}




function saveTemporaryFile( fileType, fileContent ){
	//return -1 if error
	//return file path
	var localFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
	var tempDirectory = getTempDirectory();
	var tempFilePath = tempDirectory + getSystemPathSeparator() + Math.floor( (Math.random() * Math.random() * 1000000) / Math.random() ) + fileType;
	localFile.initWithPath(tempFilePath);
	var fos = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
	fos.init(localFile, -1, -1, 0);
	fos.write(fileContent, fileContent.length, -1);
	fos.close();
	return "file:///" + tempFilePath;

}



function alertError( message ){
	alert( message );
}



function extCheckyValidateResource( service ){

	var uriToValidate = getBrowser().contentDocument.location;
	
	//-1 not a file and not a url
	//0 for file
	//1 for url
	var uriType = getUriType( uriToValidate );

	if( uriType == -1 ){
		alertError( "Uri not known." );
		return;
	}	

	//-1 not local and not online
	//0 if local
	//1 if online
	var urlType = -1;
	
	if(uriType == 1){
		urlType = getUrlType( uriToValidate );
		if( urlType == -1 ){
			alertError( "Url not known." );
			return;
		}	
	}

	//file ends with 
	var fileType = getFileType( uriToValidate );

	//return 0 if tab
	//return 1 if window
	var appearance = getAppearanceType();

	var timeout = getTimeout();

	var upload = false;

	//alert("uriType"+uriType);
	//alert("urlType"+urlType);

	//local url so upload
	if( uriType == 1 && urlType == 0){
		var request = new XMLHttpRequest();
		request.open("GET", uriToValidate, false);
		request.send(""); 
		uriToValidate = saveTemporaryFile( fileType, request.responseText );
		upload = true;
	}

	//alert("uriToValidate="+uriToValidate);

	//das ist ein file - fuer upload
	if( uriType == 0){
		upload = true;
	}

	validate( uriToValidate, service, appearance, timeout, upload );

}


function getFileType( uri ){
	var tempUri = uri.toString();
	if( ( tempUri.lastIndexOf("/") + 1) == tempUri.length){
		return ".html";
	}
	
	if( tempUri.lastIndexOf("?") > 0){
		tempUri = tempUri.substring(0, tempUri.lastIndexOf("?"));
		//alert("find ? so new uri is=" + tempUri);
		
	}

	var offset = tempUri.lastIndexOf(".");
	var fileType = tempUri.substring(offset, tempUri.length);
	if(fileType == ".xml" || fileType == ".rdf" || fileType == ".rss" || fileType == ".css" || fileType == ".html" || fileType == ".rdf"){
		//alert(fileType);
		return fileType;
	}
	else{
		//alert("no match retun html");
		return ".html";
	}
}
