/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;

public class SessionCertificateStore
implements CertificateStore {
    private Collection _certs = new HashSet();

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln("Loading certificates from JPI session certificate store");
        Trace.securityPrintln("Loaded certificates from JPI session certificate store");
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln("Saving certificates from JPI session certificate store");
        Trace.securityPrintln("Saved certificates from JPI session certificate store");
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Adding certificate in JPI session certificate store");
        this._certs.add(certificate);
        Trace.securityPrintln("Added certificate in JPI session certificate store");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Removing certificate in JPI session certificate store");
        this._certs.remove(certificate);
        Trace.securityPrintln("Removed certificate in JPI session certificate store");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Checking if certificate is in JPI session certificate store");
        return this._certs.contains(certificate);
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Check if certificate can be verified using certificates in JPI session certificate store");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.securityPrintln("Obtain certificate iterator in JPI session certificate store");
        return this._certs.iterator();
    }
}

