/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.net.www.ParseUtil;

class URLJarFile
extends JarFile {
    private static int BUF_SIZE = 2048;
    private Manifest superMan;
    private Attributes superAttr;
    private Map superEntries;

    static JarFile getJarFile(URL uRL) throws IOException {
        if (URLJarFile.isFileURL(uRL)) {
            return new URLJarFile(uRL);
        }
        return URLJarFile.retrieve(uRL);
    }

    private URLJarFile(File file) throws IOException {
        super(file, true, 5);
    }

    private URLJarFile(URL uRL) throws IOException {
        super(ParseUtil.decode(uRL.getFile()));
    }

    private static boolean isFileURL(URL uRL) {
        return uRL.getProtocol().equalsIgnoreCase("file");
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            if (zipEntry instanceof JarEntry) {
                return new URLJarFileEntry((JarEntry)zipEntry);
            }
            throw new InternalError(super.getClass() + " returned unexpected entry type " + zipEntry.getClass());
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        if (!this.isSuperMan()) {
            return null;
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putAll((Map)this.superAttr.clone());
        if (this.superEntries != null) {
            Map map = manifest.getEntries();
            Iterator iterator = this.superEntries.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Attributes attributes2 = (Attributes)this.superEntries.get(object);
                map.put(object, attributes2.clone());
            }
        }
        return manifest;
    }

    private synchronized boolean isSuperMan() throws IOException {
        if (this.superMan == null) {
            this.superMan = super.getManifest();
        }
        if (this.superMan != null) {
            this.superAttr = this.superMan.getMainAttributes();
            this.superEntries = this.superMan.getEntries();
            return true;
        }
        return false;
    }

    private static JarFile retrieve(URL uRL) throws IOException {
        JarFile jarFile = null;
        final InputStream inputStream = uRL.openConnection().getInputStream();
        try {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() throws IOException {
                    URLJarFile uRLJarFile;
                    FileOutputStream fileOutputStream;
                    block4: {
                        fileOutputStream = null;
                        try {
                            File file = File.createTempFile("jar_cache", null);
                            fileOutputStream = new FileOutputStream(file);
                            int n = 0;
                            byte[] byArray = new byte[BUF_SIZE];
                            while ((n = inputStream.read(byArray)) != -1) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                            }
                            ((OutputStream)fileOutputStream).close();
                            fileOutputStream = null;
                            uRLJarFile = new URLJarFile(file);
                            Object var7_6 = null;
                            if (inputStream == null) break block4;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (fileOutputStream == null) throw throwable;
                            ((OutputStream)fileOutputStream).close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    if (fileOutputStream == null) return uRLJarFile;
                    ((OutputStream)fileOutputStream).close();
                    return uRLJarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return jarFile;
    }

    private class URLJarFileEntry
    extends JarEntry {
        private JarEntry je;

        URLJarFileEntry(JarEntry jarEntry) {
            super(jarEntry);
            this.je = jarEntry;
        }

        public Attributes getAttributes() throws IOException {
            Attributes attributes;
            Map map;
            if (URLJarFile.this.isSuperMan() && (map = URLJarFile.this.superEntries) != null && (attributes = (Attributes)map.get(this.getName())) != null) {
                return (Attributes)attributes.clone();
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = this.je.getCertificates();
            return certificateArray == null ? null : (Certificate[])certificateArray.clone();
        }
    }
}

