/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SimpleRenderPipe;

public class DrawToFillConverter
extends DuctusRenderer
implements ShapeDrawPipe {
    SimpleRenderPipe outpipe;
    ShapeDrawPipe fillpipe;
    boolean doTx;

    public DrawToFillConverter(SimpleRenderPipe simpleRenderPipe, ShapeDrawPipe shapeDrawPipe, boolean bl) {
        this.outpipe = simpleRenderPipe;
        this.fillpipe = shapeDrawPipe;
        this.doTx = bl;
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator();
        try {
            this.draw2(sunGraphics2D, shapeSpanIterator, shape);
            Object var5_4 = null;
            shapeSpanIterator.dispose();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            shapeSpanIterator.dispose();
            throw throwable;
        }
    }

    public void draw2(SunGraphics2D sunGraphics2D, ShapeSpanIterator shapeSpanIterator, Shape shape) {
        shapeSpanIterator.setOutputArea(sunGraphics2D.getCompBounds());
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            shapeSpanIterator.setRule(1);
            BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
            AffineTransform affineTransform = sunGraphics2D.transformState == 2 ? sunGraphics2D.transform : null;
            PathConsumer pathConsumer = DuctusRenderer.createStroker(shapeSpanIterator, basicStroke, affineTransform);
            affineTransform = this.doTx && sunGraphics2D.transformState != 0 ? sunGraphics2D.transform : null;
            PathIterator pathIterator = shape.getPathIterator(affineTransform);
            try {
                boolean bl = sunGraphics2D.strokeHint != 2;
                DuctusRenderer.feedConsumer(pathIterator, pathConsumer, bl, 0.25f);
            }
            catch (PathException pathException) {
                throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
            }
        } else {
            shape = sunGraphics2D.stroke.createStrokedShape(shape);
            AffineTransform affineTransform = this.doTx && sunGraphics2D.transformState != 0 ? sunGraphics2D.transform : null;
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
        }
        this.outpipe.fillSpans(sunGraphics2D, shapeSpanIterator);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.fillpipe.fill(sunGraphics2D, shape);
    }
}

