/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ByteBandedRaster
extends WritableRaster {
    int[] dataOffsets;
    int scanlineStride;
    byte[][] data;

    public ByteBandedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteBandedRaster byteBandedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteBandedRaster);
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteBandedRaster must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bandedSampleModel = (BandedSampleModel)sampleModel;
            this.scanlineStride = bandedSampleModel.getScanlineStride();
            int[] nArray = bandedSampleModel.getBankIndices();
            int[] nArray2 = bandedSampleModel.getBandOffsets();
            int[] nArray3 = dataBufferByte.getOffsets();
            this.dataOffsets = new int[nArray.length];
            this.data = new byte[nArray.length][];
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            int n3 = 0;
            while (n3 < nArray.length) {
                this.data[n3] = dataBufferByte.getData(nArray[n3]);
                this.dataOffsets[n3] = nArray3[nArray[n3]] + n + n2 * this.scanlineStride + nArray2[n3];
                ++n3;
            }
        } else {
            throw new RasterFormatException("ByteBandedRasters must haveBandedSampleModels");
        }
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return 1;
    }

    public byte[][] getDataStorage() {
        return this.data;
    }

    public byte[] getDataStorage(int n) {
        return this.data[n];
    }

    public Object getDataElements(int n, int n2, Object object) {
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n4 = 0;
        while (n4 < this.numDataElements) {
            byArray[n4] = this.data[n4][this.dataOffsets[n4] + n3];
            ++n4;
        }
        return byArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        byte[] byArray = object == null ? new byte[this.numDataElements * n3 * n4] : (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            byte[] byArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = n5;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n8 + n9;
                int n12 = 0;
                while (n12 < n3) {
                    byArray[n7] = byArray2[n11++];
                    n7 += this.numDataElements;
                    ++n12;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
            ++n6;
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        if (this.scanlineStride == n3) {
            System.arraycopy(this.data[n5], n6, byArray, 0, n3 * n4);
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(this.data[n5], n6, byArray, n7, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            byte[] byArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = n5;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n8 + n9;
                int n12 = 0;
                while (n12 < n3) {
                    byArray[n7] = byArray2[n11++];
                    n7 += this.numDataElements;
                    ++n12;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
            ++n6;
        }
        return byArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        byte[] byArray = (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n4 = 0;
        while (n4 < this.numDataElements) {
            this.data[n4][this.dataOffsets[n4] + n3] = byArray[n4];
            ++n4;
        }
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        Object object = null;
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        if (raster instanceof ByteBandedRaster) {
            // empty if block
        }
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                object = raster.getDataElements(n5 + n8, n6 + n7, object);
                this.setDataElements(n + n8, n2 + n7, object);
                ++n8;
            }
            ++n7;
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        byte[] byArray = (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            byte[] byArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = n5;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n8 + n9;
                int n12 = 0;
                while (n12 < n3) {
                    byArray2[n11++] = byArray[n7];
                    n7 += this.numDataElements;
                    ++n12;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
            ++n6;
        }
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        int n7 = 0;
        if (this.scanlineStride == n3) {
            System.arraycopy(byArray, 0, this.data[n5], n6, n3 * n4);
        } else {
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(byArray, n7, this.data[n5], n6, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            byte[] byArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = n5;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n8 + n9;
                int n12 = 0;
                while (n12 < n3) {
                    byArray2[n11++] = byArray[n7];
                    n7 += this.numDataElements;
                    ++n12;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
            ++n6;
        }
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n + n3 > this.width + this.minX) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n2 + n4 > this.height + this.minY) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        if (nArray != null) {
            SampleModel sampleModel = this.sampleModel.createSubsetSampleModel(nArray);
        } else {
            SampleModel sampleModel = this.sampleModel;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ByteBandedRaster(this.sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ByteBandedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        int n = 0;
        while (n < this.dataOffsets.length) {
            if (this.dataOffsets[n] < 0) {
                throw new RasterFormatException("Data offsets for band " + n + "(" + this.dataOffsets[n] + ") must be >= 0");
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numDataElements) {
            int n4 = (this.height - 1) * this.scanlineStride + (this.width - 1) + this.dataOffsets[n3];
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (this.data.length == 1) {
            if (this.data[0].length < n2 * this.numDataElements) {
                throw new RasterFormatException("Data array too small (it is " + this.data[0].length + " and should be " + n2 * this.numDataElements + " )");
            }
        } else {
            int n5 = 0;
            while (n5 < this.numDataElements) {
                if (this.data[n5].length < n2) {
                    throw new RasterFormatException("Data array too small (it is " + this.data[n5].length + " and should be " + n2 + " )");
                }
                ++n5;
            }
        }
    }

    public String toString() {
        return new String("ByteBandedRaster: width = " + this.width + " height = " + this.height + " #bands " + this.numDataElements + " minX = " + this.minX + " minY = " + this.minY);
    }
}

