/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.im.spi.InputMethod;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.awt.SunToolkit;
import sun.awt.im.CompositionAreaHandler;
import sun.awt.im.InputContext;
import sun.security.action.GetPropertyAction;

public class InputMethodContext
extends InputContext
implements java.awt.im.spi.InputMethodContext {
    private boolean dispatchingCommittedText;
    private CompositionAreaHandler compositionAreaHandler;
    private static boolean belowTheSpotInputRequested;
    private boolean inputMethodSupportsBelowTheSpot;

    void setInputMethodSupportsBelowTheSpot(boolean bl) {
        this.inputMethodSupportsBelowTheSpot = bl;
    }

    private boolean useBelowTheSpotInput() {
        return belowTheSpotInputRequested && this.inputMethodSupportsBelowTheSpot;
    }

    private boolean haveActiveClient() {
        Component component = this.getClientComponent();
        return component != null && component.getInputMethodRequests() != null;
    }

    public void dispatchInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        Component component = this.getClientComponent();
        InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
        if (this.haveActiveClient() && !this.useBelowTheSpotInput()) {
            component.dispatchEvent(inputMethodEvent);
        } else {
            this.getCompositionAreaHandler(true).processInputMethodEvent(inputMethodEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void dispatchCommittedText(Component component, AttributedCharacterIterator attributedCharacterIterator, int n) {
        if (n == 0) return;
        if (attributedCharacterIterator.getEndIndex() <= attributedCharacterIterator.getBeginIndex()) {
            return;
        }
        long l = System.currentTimeMillis();
        this.dispatchingCommittedText = true;
        try {
            InputMethodRequests inputMethodRequests = component.getInputMethodRequests();
            if (inputMethodRequests != null) {
                int n2 = attributedCharacterIterator.getBeginIndex();
                AttributedCharacterIterator attributedCharacterIterator2 = new AttributedString(attributedCharacterIterator, n2, n2 + n).getIterator();
                InputMethodEvent inputMethodEvent = new InputMethodEvent(component, 1100, attributedCharacterIterator2, n, null, null);
                component.dispatchEvent(inputMethodEvent);
            } else {
                char c = attributedCharacterIterator.first();
                while (n-- > 0) {
                    if (c == '\uffff') {
                        break;
                    }
                    KeyEvent keyEvent = new KeyEvent(component, 400, l, 0, 0, c);
                    component.dispatchEvent(keyEvent);
                    c = attributedCharacterIterator.next();
                }
            }
            Object var11_11 = null;
            this.dispatchingCommittedText = false;
            return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.dispatchingCommittedText = false;
            throw throwable;
        }
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputMethodEvent) {
            if (((Component)aWTEvent.getSource()).getInputMethodRequests() == null || this.useBelowTheSpotInput() && !this.dispatchingCommittedText) {
                this.getCompositionAreaHandler(true).processInputMethodEvent((InputMethodEvent)aWTEvent);
            }
        } else if (!this.dispatchingCommittedText) {
            super.dispatchEvent(aWTEvent);
        }
    }

    private synchronized CompositionAreaHandler getCompositionAreaHandler(boolean bl) {
        if (this.compositionAreaHandler == null) {
            this.compositionAreaHandler = new CompositionAreaHandler(this);
        }
        this.compositionAreaHandler.setClientComponent(this.getClientComponent());
        if (bl) {
            this.compositionAreaHandler.grabCompositionArea(false);
        }
        return this.compositionAreaHandler;
    }

    synchronized void grabCompositionArea(boolean bl) {
        if (this.compositionAreaHandler != null) {
            this.compositionAreaHandler.grabCompositionArea(bl);
        } else {
            CompositionAreaHandler.closeCompositionArea();
        }
    }

    synchronized void releaseCompositionArea() {
        if (this.compositionAreaHandler != null) {
            this.compositionAreaHandler.releaseCompositionArea();
        }
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        return this.getReq().getTextLocation(textHitInfo);
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        return this.getReq().getLocationOffset(n, n2);
    }

    public int getInsertPositionOffset() {
        return this.getReq().getInsertPositionOffset();
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getCommittedText(n, n2, attributeArray);
    }

    public int getCommittedTextLength() {
        return this.getReq().getCommittedTextLength();
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().cancelLatestCommittedText(attributeArray);
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getSelectedText(attributeArray);
    }

    private InputMethodRequests getReq() {
        if (this.haveActiveClient() && !this.useBelowTheSpotInput()) {
            return this.getClientComponent().getInputMethodRequests();
        }
        return this.getCompositionAreaHandler(false);
    }

    public Window createInputMethodWindow(String string, boolean bl) {
        InputMethodContext inputMethodContext = bl ? this : null;
        return InputMethodContext.createInputMethodWindow(string, inputMethodContext);
    }

    static Window createInputMethodWindow(String string, InputContext inputContext) {
        SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
        return sunToolkit.createInputMethodWindow(string, inputContext);
    }

    public void enableClientWindowNotification(InputMethod inputMethod, boolean bl) {
        super.enableClientWindowNotification(inputMethod, bl);
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.awt.im.style", null));
        if (string == null) {
            Toolkit.getDefaultToolkit();
            string = Toolkit.getProperty("java.awt.im.style", null);
        }
        belowTheSpotInputRequested = "below-the-spot".equals(string);
    }
}

