/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class SmartGridLayout
implements LayoutManager,
Serializable {
    int rows = 2;
    int columns = 2;
    int xGap = 2;
    int yGap = 2;
    int componentCount = 0;
    Component[][] layoutGrid;

    public SmartGridLayout(int n, int n2) {
        this.rows = n2;
        this.columns = n;
        this.layoutGrid = new Component[n][n2];
    }

    public void layoutContainer(Container container) {
        this.buildLayoutGrid(container);
        int[] nArray = new int[this.rows];
        int[] nArray2 = new int[this.columns];
        int n = 0;
        while (n < this.rows) {
            nArray[n] = this.computeRowHeight(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.columns) {
            nArray2[n2] = this.computeColumnWidth(n2);
            ++n2;
        }
        Insets insets = container.getInsets();
        int n3 = insets.left;
        int n4 = 0;
        while (n4 < this.columns) {
            int n5 = insets.top;
            int n6 = 0;
            while (n6 < this.rows) {
                Component component = this.layoutGrid[n4][n6];
                component.setBounds(n3, n5, nArray2[n4], nArray[n6]);
                n5 += nArray[n6] + this.yGap;
                ++n6;
            }
            n3 += nArray2[n4] + this.xGap;
            ++n4;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        this.buildLayoutGrid(container);
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows) {
            n += this.computeRowHeight(n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.columns) {
            n2 += this.computeColumnWidth(n4);
            ++n4;
        }
        return new Dimension(n2 += this.xGap * (this.columns - 1) + insets.right + insets.left, n += this.yGap * (this.rows - 1) + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private void buildLayoutGrid(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                n3 = n % this.columns;
                n2 = (n - n3) / this.columns;
            }
            this.layoutGrid[n3][n2] = componentArray[n];
            ++n;
        }
    }

    private int computeColumnWidth(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.rows) {
            int n4 = this.layoutGrid[n][n3].getPreferredSize().width;
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2;
    }

    private int computeRowHeight(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.columns) {
            int n4 = this.layoutGrid[n3][n].getPreferredSize().height;
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2;
    }
}

