/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.Filter;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.UnsolicitedResponseImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.ldap.Control;

public final class LdapClient {
    private static final int debug = 0;
    static final boolean caseIgnore = true;
    private static final Hashtable defaultBinaryAttrs = new Hashtable(23, 0.75f);
    private static final String DISCONNECT_OID = "1.3.6.1.4.1.1466.20036";
    boolean isLdapv3;
    int referenceCount = 1;
    private Connection conn;
    static final int SCOPE_BASE_OBJECT = 0;
    static final int SCOPE_ONE_LEVEL = 1;
    static final int SCOPE_SUBTREE = 2;
    static final int ADD = 0;
    static final int DELETE = 1;
    static final int REPLACE = 2;
    static final int LDAP_VERSION3_VERSION2 = 32;
    static final int LDAP_VERSION2 = 2;
    static final int LDAP_VERSION3 = 3;
    static final int LDAP_VERSION = 3;
    static final int LDAP_REF_FOLLOW = 1;
    static final int LDAP_REF_THROW = 2;
    static final int LDAP_REF_IGNORE = 3;
    static final String LDAP_URL = "ldap://";
    static final String LDAPS_URL = "ldaps://";
    static final int LBER_BOOLEAN = 1;
    static final int LBER_INTEGER = 2;
    static final int LBER_BITSTRING = 3;
    static final int LBER_OCTETSTRING = 4;
    static final int LBER_NULL = 5;
    static final int LBER_ENUMERATED = 10;
    static final int LBER_SEQUENCE = 48;
    static final int LBER_SET = 49;
    static final int LDAP_SUPERIOR_DN = 128;
    static final int LDAP_REQ_BIND = 96;
    static final int LDAP_REQ_UNBIND = 66;
    static final int LDAP_REQ_SEARCH = 99;
    static final int LDAP_REQ_MODIFY = 102;
    static final int LDAP_REQ_ADD = 104;
    static final int LDAP_REQ_DELETE = 74;
    static final int LDAP_REQ_MODRDN = 108;
    static final int LDAP_REQ_COMPARE = 110;
    static final int LDAP_REQ_ABANDON = 80;
    static final int LDAP_REQ_EXTENSION = 119;
    static final int LDAP_REP_BIND = 97;
    static final int LDAP_REP_SEARCH = 100;
    static final int LDAP_REP_SEARCH_REF = 115;
    static final int LDAP_REP_RESULT = 101;
    static final int LDAP_REP_MODIFY = 103;
    static final int LDAP_REP_ADD = 105;
    static final int LDAP_REP_DELETE = 107;
    static final int LDAP_REP_MODRDN = 109;
    static final int LDAP_REP_COMPARE = 111;
    static final int LDAP_REP_EXTENSION = 120;
    static final int LDAP_REP_REFERRAL = 163;
    static final int LDAP_REP_EXT_OID = 138;
    static final int LDAP_REP_EXT_VAL = 139;
    static final int LDAP_CONTROLS = 160;
    static final String LDAP_CONTROL_MANAGE_DSA_IT = "2.16.840.1.113730.3.4.2";
    static final String LDAP_CONTROL_PREFERRED_LANG = "1.3.6.1.4.1.1466.20035";
    static final String LDAP_CONTROL_PAGED_RESULTS = "1.2.840.113556.1.4.319";
    static final String LDAP_CONTROL_SERVER_SORT_REQ = "1.2.840.113556.1.4.473";
    static final String LDAP_CONTROL_SERVER_SORT_RES = "1.2.840.113556.1.4.474";
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_OPERATIONS_ERROR = 1;
    static final int LDAP_PROTOCOL_ERROR = 2;
    static final int LDAP_TIME_LIMIT_EXCEEDED = 3;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_COMPARE_FALSE = 5;
    static final int LDAP_COMPARE_TRUE = 6;
    static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    static final int LDAP_PARTIAL_RESULTS = 9;
    static final int LDAP_REFERRAL = 10;
    static final int LDAP_ADMIN_LIMIT_EXCEEDED = 11;
    static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    static final int LDAP_UNDEFINED_ATTRIBUTE_TYPE = 17;
    static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    static final int LDAP_CONSTRAINT_VIOLATION = 19;
    static final int LDAP_ATTRIBUTE_OR_VALUE_EXISTS = 20;
    static final int LDAP_INVALID_ATTRIBUTE_SYNTAX = 21;
    static final int LDAP_NO_SUCH_OBJECT = 32;
    static final int LDAP_ALIAS_PROBLEM = 33;
    static final int LDAP_INVALID_DN_SYNTAX = 34;
    static final int LDAP_IS_LEAF = 35;
    static final int LDAP_ALIAS_DEREFERENCING_PROBLEM = 36;
    static final int LDAP_INAPPROPRIATE_AUTHENTICATION = 48;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_INSUFFICIENT_ACCESS_RIGHTS = 50;
    static final int LDAP_BUSY = 51;
    static final int LDAP_UNAVAILABLE = 52;
    static final int LDAP_UNWILLING_TO_PERFORM = 53;
    static final int LDAP_LOOP_DETECT = 54;
    static final int LDAP_NAMING_VIOLATION = 64;
    static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    static final int LDAP_NOT_ALLOWED_ON_NON_LEAF = 66;
    static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    static final int LDAP_ENTRY_ALREADY_EXISTS = 68;
    static final int LDAP_OBJECT_CLASS_MODS_PROHIBITED = 69;
    static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    static final int LDAP_OTHER = 80;
    static final String[] ldap_error_message;
    private Vector unsolicited = new Vector(3);
    static /* synthetic */ Class class$com$sun$jndi$ldap$LdapClient;
    static /* synthetic */ Class class$com$sun$jndi$ldap$Connection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class array$Ljavax$naming$ldap$Control;

    LdapClient(String string, int n, String string2, OutputStream outputStream) throws NamingException {
        this.conn = new Connection(this, string, n, string2, outputStream);
    }

    /*
     * Unable to fully structure code
     */
    synchronized LdapResult authenticate(boolean var1_1, String var2_2, Object var3_3, int var4_4, String var5_5, Control[] var6_6, Hashtable var7_7) throws NamingException {
        block33: {
            block30: {
                switch (var4_4) {
                    case 3: 
                    case 32: {
                        this.isLdapv3 = true;
                        break;
                    }
                    case 2: {
                        this.isLdapv3 = false;
                        break;
                    }
                    default: {
                        throw new CommunicationException("Protocol version " + var4_4 + " not supported");
                    }
                }
                var8_8 = null;
                if (var5_5.equalsIgnoreCase("none") || var5_5.equalsIgnoreCase("anonymous")) {
                    if (!var1_1 || var4_4 == 2 || var4_4 == 32) {
                        try {
                            var2_2 = null;
                            var3_3 = null;
                            var8_8 = this.ldapBind(null, null, var6_6, null);
                            if (var8_8.status != 0) ** GOTO lbl71
                            this.conn.setBound();
                        }
                        catch (IOException var9_9) {
                            var10_12 = new CommunicationException("anonymous bind failed: " + this.conn.host + ":" + this.conn.port);
                            var10_12.setRootCause(var9_9);
                            throw var10_12;
                        }
                    } else {
                        var8_8 = new LdapResult();
                        var8_8.status = 0;
                    }
                } else {
                    if (var5_5.equalsIgnoreCase("simple")) {
                        block31: {
                            var9_10 = null;
                            try {
                                block29: {
                                    var9_10 = LdapClient.encodePassword(var3_3, this.isLdapv3);
                                    var8_8 = this.ldapBind(var2_2, var9_10, var6_6, null);
                                    if (var8_8.status != 0) break block29;
                                    this.conn.setBound();
                                }
                                var13_16 = null;
                                if (var9_10 == var3_3 || var9_10 == null) break block30;
                                var14_18 = 0;
                                ** while (var14_18 < var9_10.length)
                            }
                            catch (Throwable var12_22) {
                                var13_17 = null;
                                if (var9_10 == var3_3 || var9_10 == null) break block31;
                                var14_19 = 0;
                                ** while (var14_19 < var9_10.length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                var9_10[var14_18] = 0;
                                ++var14_18;
                                continue;
                            }
lbl-1000:
                            // 1 sources

                            {
                                break block30;
                                catch (IOException var10_13) {
                                    var11_20 = new CommunicationException("simple bind failed: " + this.conn.host + ":" + this.conn.port);
                                    var11_20.setRootCause(var10_13);
                                    throw var11_20;
                                }
                            }
lbl-1000:
                            // 1 sources

                            {
                                var9_10[var14_19] = 0;
                                ++var14_19;
                                continue;
                            }
                        }
                        throw var12_22;
                    }
                    if (this.isLdapv3) {
                        try {
                            var8_8 = this.saslBind(this.conn.host, var2_2, var3_3, var5_5, var7_7, var6_6);
                            if (var8_8.status != 0) ** GOTO lbl71
                            this.conn.setBound();
                        }
                        catch (IOException var9_11) {
                            var10_14 = new CommunicationException("SASL bind failed: " + this.conn.host + ":" + this.conn.port);
                            var10_14.setRootCause(var9_11);
                            throw var10_14;
                        }
                    } else {
                        throw new AuthenticationNotSupportedException(var5_5);
                    }
                }
            }
            if (var1_1 && var8_8.status == 2 && var4_4 == 32 && (var5_5.equalsIgnoreCase("none") || var5_5.equalsIgnoreCase("anonymous") || var5_5.equalsIgnoreCase("simple"))) {
                block34: {
                    var9_10 = null;
                    try {
                        block32: {
                            this.isLdapv3 = false;
                            var9_10 = LdapClient.encodePassword(var3_3, false);
                            var8_8 = this.ldapBind(var2_2, var9_10, var6_6, null);
                            if (var8_8.status != 0) break block32;
                            this.conn.setBound();
                        }
                        var16_23 = null;
                        if (var9_10 == var3_3 || var9_10 == null) break block33;
                        var17_25 = 0;
                        ** while (var17_25 < var9_10.length)
                    }
                    catch (Throwable var15_27) {
                        var16_24 = null;
                        if (var9_10 == var3_3 || var9_10 == null) break block34;
                        var17_26 = 0;
                        ** while (var17_26 < var9_10.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var9_10[var17_25] = 0;
                        ++var17_25;
                        continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block33;
                        catch (IOException var10_15) {
                            var11_21 = new CommunicationException(var5_5 + ":" + this.conn.host + ":" + this.conn.port);
                            var11_21.setRootCause(var10_15);
                            throw var11_21;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        var9_10[var17_26] = 0;
                        ++var17_26;
                        continue;
                    }
                }
                throw var15_27;
            }
        }
        if (var8_8.status == 32) {
            throw new AuthenticationException(LdapClient.getErrorMessage(var8_8.status, var8_8.errorMessage));
        }
        this.conn.setV3(this.isLdapv3);
        return var8_8;
    }

    public synchronized LdapResult ldapBind(String string, byte[] byArray, Control[] controlArray, String string2) throws IOException, NamingException {
        this.ensureOpen();
        this.conn.abandonOutstandingReqs(null);
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(96);
        berEncoder.encodeInt(this.isLdapv3 ? 3 : 2);
        berEncoder.encodeString(string, this.isLdapv3);
        if (string2 != null) {
            berEncoder.beginSeq(163);
            berEncoder.encodeString(string2, this.isLdapv3);
            if (byArray != null) {
                berEncoder.encodeOctetString(byArray, 4);
            }
            berEncoder.endSeq();
        } else if (byArray != null) {
            berEncoder.encodeOctetString(byArray, 128);
        } else {
            berEncoder.encodeOctetString(null, 128, 0, 0);
        }
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        if (byArray != null) {
            berEncoder.reset();
        }
        BerDecoder berDecoder = this.conn.readReply(ldapRequest);
        berDecoder.parseSeq(null);
        berDecoder.parseInt();
        if (berDecoder.parseByte() != 97) {
            return ldapResult;
        }
        berDecoder.parseLength();
        LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
        if (this.isLdapv3 && berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 135) {
            ldapResult.serverCreds = berDecoder.parseOctetString(135, null);
        }
        ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
        this.conn.removeRequest(ldapRequest);
        return ldapResult;
    }

    private LdapResult saslBind(String string, String string2, Object object, String string3, Hashtable hashtable, Control[] controlArray) throws IOException, NamingException {
        Method method = LdapClient.getSaslBindMethod();
        if (method != null) {
            try {
                return (LdapResult)method.invoke(null, new Object[]{this, this.conn, string, string2, object, string3, hashtable, controlArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof NamingException) {
                    throw (NamingException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                AuthenticationException authenticationException = new AuthenticationException("SASL authentication failed");
                authenticationException.setRootCause(throwable);
                throw authenticationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                AuthenticationNotSupportedException authenticationNotSupportedException = new AuthenticationNotSupportedException("Cannot access saslBind method");
                authenticationNotSupportedException.setRootCause(illegalAccessException);
                throw authenticationNotSupportedException;
            }
        }
        throw new AuthenticationNotSupportedException("SASL support not available: " + string3);
    }

    synchronized void incRefCount() {
        ++this.referenceCount;
    }

    private static byte[] encodePassword(Object object, boolean bl) throws IOException {
        if (object instanceof char[]) {
            object = new String((char[])object);
        }
        if (object instanceof String) {
            if (bl) {
                return ((String)object).getBytes("UTF8");
            }
            return ((String)object).getBytes("8859_1");
        }
        return (byte[])object;
    }

    private static Method getSaslBindMethod() {
        try {
            Class clazz = Obj.helper.loadClass("com.sun.jndi.ldap.sasl.LdapSasl");
            return clazz.getMethod("saslBind", new Class[]{class$com$sun$jndi$ldap$LdapClient == null ? (class$com$sun$jndi$ldap$LdapClient = LdapClient.class$("com.sun.jndi.ldap.LdapClient")) : class$com$sun$jndi$ldap$LdapClient, class$com$sun$jndi$ldap$Connection == null ? (class$com$sun$jndi$ldap$Connection = LdapClient.class$("com.sun.jndi.ldap.Connection")) : class$com$sun$jndi$ldap$Connection, class$java$lang$String == null ? (class$java$lang$String = LdapClient.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LdapClient.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = LdapClient.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = LdapClient.class$("java.lang.String")) : class$java$lang$String, class$java$util$Hashtable == null ? (class$java$util$Hashtable = LdapClient.class$("java.util.Hashtable")) : class$java$util$Hashtable, array$Ljavax$naming$ldap$Control == null ? (array$Ljavax$naming$ldap$Control = LdapClient.class$("[Ljavax.naming.ldap.Control;")) : array$Ljavax$naming$ldap$Control});
        }
        catch (Exception exception) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    synchronized void close(Control[] controlArray) {
        --this.referenceCount;
        if (this.referenceCount <= 0 && this.conn != null) {
            this.conn.cleanup(controlArray);
            this.conn = null;
        }
    }

    private void forceClose() {
        this.referenceCount = 0;
        if (this.conn != null) {
            this.conn.cleanup(null);
            this.conn = null;
        }
    }

    protected void finalize() {
        this.forceClose();
    }

    LdapResult search(String string, int n, int n2, int n3, int n4, boolean bl, String[] stringArray, String string2, int n5, Control[] controlArray, Hashtable hashtable, boolean bl2) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        BerEncoder berEncoder = new BerEncoder();
        int n6 = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n6);
        berEncoder.beginSeq(99);
        berEncoder.encodeString(string == null ? "" : string, this.isLdapv3);
        berEncoder.encodeInt(n, 10);
        berEncoder.encodeInt(n2, 10);
        berEncoder.encodeInt(n3);
        berEncoder.encodeInt(n4);
        berEncoder.encodeBoolean(bl);
        Filter.encodeFilterString(berEncoder, string2, this.isLdapv3);
        berEncoder.beginSeq(48);
        berEncoder.encodeStringArray(stringArray, this.isLdapv3);
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n6);
        ldapResult.msgId = n6;
        ldapResult.status = 0;
        if (bl2) {
            ldapResult = this.getSearchReply(ldapRequest, n5, ldapResult, hashtable);
        }
        return ldapResult;
    }

    void clearSearchReply(LdapResult ldapResult, Control[] controlArray) {
        this.clearSearchReply(ldapResult, controlArray, true);
    }

    void clearSearchReply(LdapResult ldapResult, Control[] controlArray, boolean bl) {
        if (ldapResult != null && this.conn != null) {
            LdapRequest ldapRequest = this.conn.findRequest(ldapResult.msgId);
            if (ldapRequest == null) {
                return;
            }
            if (bl) {
                this.conn.abandonRequest(ldapRequest, controlArray);
            } else {
                this.conn.removeRequest(ldapRequest);
            }
        }
    }

    LdapResult getSearchReply(int n, LdapResult ldapResult, Hashtable hashtable) throws IOException, NamingException {
        this.ensureOpen();
        LdapRequest ldapRequest = this.conn.findRequest(ldapResult.msgId);
        if (ldapRequest == null) {
            return null;
        }
        return this.getSearchReply(ldapRequest, n, ldapResult, hashtable);
    }

    private LdapResult getSearchReply(LdapRequest ldapRequest, int n, LdapResult ldapResult, Hashtable hashtable) throws IOException, NamingException {
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        if (ldapResult.entries != null) {
            ldapResult.entries.setSize(0);
        } else {
            ldapResult.entries = new Vector(n == Integer.MAX_VALUE ? 32 : n);
        }
        if (ldapResult.referrals != null) {
            ldapResult.referrals.setSize(0);
        }
        int n2 = 0;
        while (n2 < n) {
            BerDecoder berDecoder = this.conn.readReply(ldapRequest);
            berDecoder.parseSeq(null);
            berDecoder.parseInt();
            int n3 = berDecoder.parseSeq(null);
            if (n3 == 100) {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                String string = berDecoder.parseString(this.isLdapv3);
                LdapEntry ldapEntry = new LdapEntry(string, basicAttributes);
                int[] nArray = new int[1];
                berDecoder.parseSeq(nArray);
                int n4 = berDecoder.getParsePosition() + nArray[0];
                while (berDecoder.getParsePosition() < n4 && berDecoder.bytesLeft() > 0) {
                    Attribute attribute = this.parseAttribute(berDecoder, hashtable);
                    basicAttributes.put(attribute);
                }
                ldapEntry.respCtls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
                ldapResult.entries.addElement(ldapEntry);
                ++n2;
                continue;
            }
            if (n3 == 115 && this.isLdapv3) {
                Vector vector = new Vector(4);
                if (berDecoder.peekByte() == 48) {
                    berDecoder.parseSeq(null);
                }
                while (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 4) {
                    vector.addElement(berDecoder.parseString(this.isLdapv3));
                }
                if (ldapResult.referrals == null) {
                    ldapResult.referrals = new Vector(4);
                }
                ldapResult.referrals.addElement(vector);
                ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
                continue;
            }
            if (n3 == 120) {
                this.parseExtResponse(berDecoder, ldapResult);
                continue;
            }
            if (n3 != 101) continue;
            LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
            ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
            this.conn.removeRequest(ldapRequest);
            return ldapResult;
        }
        return ldapResult;
    }

    private Attribute parseAttribute(BerDecoder berDecoder, Hashtable hashtable) throws IOException {
        int[] nArray = new int[1];
        int n = berDecoder.parseSeq(null);
        LdapAttribute ldapAttribute = new LdapAttribute(berDecoder.parseString(this.isLdapv3));
        n = berDecoder.parseSeq(nArray);
        if (n == 49) {
            for (int i = nArray[0]; berDecoder.bytesLeft() > 0 && i > 0; i -= this.parseAttributeValue(berDecoder, ldapAttribute, hashtable)) {
                try {
                    continue;
                }
                catch (IOException iOException) {
                    berDecoder.seek(i);
                    break;
                }
            }
        } else {
            berDecoder.seek(nArray[0]);
        }
        return ldapAttribute;
    }

    private int parseAttributeValue(BerDecoder berDecoder, Attribute attribute, Hashtable hashtable) throws IOException {
        int[] nArray = new int[1];
        if (this.isBinary(attribute, hashtable)) {
            attribute.add(berDecoder.parseOctetString(berDecoder.peekByte(), nArray));
        } else {
            attribute.add(berDecoder.parseStringWithTag(4, this.isLdapv3, nArray));
        }
        return nArray[0];
    }

    private boolean isBinary(Attribute attribute, Hashtable hashtable) {
        String string = attribute.getID().toLowerCase();
        return string.indexOf(";binary") != -1 || defaultBinaryAttrs.containsKey(string) || hashtable != null && hashtable.containsKey(string);
    }

    static void parseResult(BerDecoder berDecoder, LdapResult ldapResult, boolean bl) throws IOException {
        ldapResult.status = berDecoder.parseEnumeration();
        ldapResult.matchedDN = berDecoder.parseString(bl);
        ldapResult.errorMessage = berDecoder.parseString(bl);
        if (bl && berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 163) {
            Vector vector = new Vector(4);
            int[] nArray = new int[1];
            berDecoder.parseSeq(nArray);
            int n = berDecoder.getParsePosition() + nArray[0];
            while (berDecoder.getParsePosition() < n && berDecoder.bytesLeft() > 0) {
                vector.addElement(berDecoder.parseString(bl));
            }
            if (ldapResult.referrals == null) {
                ldapResult.referrals = new Vector(4);
            }
            ldapResult.referrals.addElement(vector);
        }
    }

    static Vector parseControls(BerDecoder berDecoder) throws IOException {
        if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 160) {
            Vector vector = new Vector(4);
            boolean bl = false;
            byte[] byArray = null;
            int[] nArray = new int[1];
            berDecoder.parseSeq(nArray);
            int n = berDecoder.getParsePosition() + nArray[0];
            while (berDecoder.getParsePosition() < n && berDecoder.bytesLeft() > 0) {
                berDecoder.parseSeq(null);
                String string = berDecoder.parseString(true);
                if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 1) {
                    bl = berDecoder.parseBoolean();
                }
                if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 4) {
                    byArray = berDecoder.parseOctetString(4, null);
                }
                if (string == null) continue;
                vector.addElement(new BasicControl(string, bl, byArray));
            }
            return vector;
        }
        return null;
    }

    private void parseExtResponse(BerDecoder berDecoder, LdapResult ldapResult) throws IOException {
        LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
        if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 138) {
            ldapResult.extensionId = berDecoder.parseStringWithTag(138, this.isLdapv3, null);
        }
        if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 139) {
            ldapResult.extensionValue = berDecoder.parseOctetString(139, null);
        }
        ldapResult.resControls = LdapClient.parseControls(berDecoder);
    }

    static void encodeControls(BerEncoder berEncoder, Control[] controlArray) throws IOException {
        if (controlArray == null || controlArray.length == 0) {
            return;
        }
        berEncoder.beginSeq(160);
        int n = 0;
        while (n < controlArray.length) {
            byte[] byArray;
            berEncoder.beginSeq(48);
            berEncoder.encodeString(controlArray[n].getID(), true);
            if (controlArray[n].isCritical()) {
                berEncoder.encodeBoolean(true);
            }
            if ((byArray = controlArray[n].getEncodedValue()) != null) {
                berEncoder.encodeOctetString(byArray, 4);
            }
            berEncoder.endSeq();
            ++n;
        }
        berEncoder.endSeq();
    }

    private LdapResult processReply(LdapRequest ldapRequest, LdapResult ldapResult, int n) throws IOException, NamingException {
        BerDecoder berDecoder = this.conn.readReply(ldapRequest);
        berDecoder.parseSeq(null);
        berDecoder.parseInt();
        if (berDecoder.parseByte() != n) {
            return ldapResult;
        }
        berDecoder.parseLength();
        LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
        ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
        this.conn.removeRequest(ldapRequest);
        return ldapResult;
    }

    LdapResult modify(String string, int[] nArray, Attribute[] attributeArray, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || nArray.length != attributeArray.length) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(102);
        berEncoder.encodeString(string, this.isLdapv3);
        berEncoder.beginSeq(48);
        int n2 = 0;
        while (n2 < nArray.length) {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(nArray[n2], 10);
            if (nArray[n2] == 0 && LdapClient.hasNoValue(attributeArray[n2])) {
                throw new InvalidAttributeValueException("'" + attributeArray[n2].getID() + "' has no values.");
            }
            this.encodeAttribute(berEncoder, attributeArray[n2]);
            berEncoder.endSeq();
            ++n2;
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 103);
    }

    private void encodeAttribute(BerEncoder berEncoder, Attribute attribute) throws IOException, NamingException {
        berEncoder.beginSeq(48);
        berEncoder.encodeString(attribute.getID(), this.isLdapv3);
        berEncoder.beginSeq(49);
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            Object object = namingEnumeration.next();
            if (object instanceof String) {
                berEncoder.encodeString((String)object, this.isLdapv3);
                continue;
            }
            if (object instanceof byte[]) {
                berEncoder.encodeOctetString((byte[])object, 4);
                continue;
            }
            if (object == null) continue;
            throw new InvalidAttributeValueException("Malformed '" + attribute.getID() + "' attribute value");
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
    }

    private static boolean hasNoValue(Attribute attribute) throws NamingException {
        return attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null;
    }

    LdapResult add(LdapEntry ldapEntry, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (ldapEntry == null || ldapEntry.DN == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(104);
        berEncoder.encodeString(ldapEntry.DN, this.isLdapv3);
        berEncoder.beginSeq(48);
        NamingEnumeration namingEnumeration = ldapEntry.attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = (Attribute)namingEnumeration.next();
            if (LdapClient.hasNoValue(attribute)) {
                throw new InvalidAttributeValueException("'" + attribute.getID() + "' has no values.");
            }
            this.encodeAttribute(berEncoder, attribute);
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 105);
    }

    LdapResult delete(String string, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.encodeString(string, 74, this.isLdapv3);
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 107);
    }

    LdapResult moddn(String string, String string2, boolean bl, String string3, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        boolean bl2 = string3 != null && string3.length() > 0;
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string2 == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(108);
        berEncoder.encodeString(string, this.isLdapv3);
        berEncoder.encodeString(string2, this.isLdapv3);
        berEncoder.encodeBoolean(bl);
        if (this.isLdapv3 && bl2) {
            berEncoder.encodeString(string3, 128, this.isLdapv3);
        }
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 109);
    }

    LdapResult compare(String string, String string2, String string3, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string2 == null || string3 == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(110);
        berEncoder.encodeString(string, this.isLdapv3);
        berEncoder.beginSeq(48);
        berEncoder.encodeString(string2, this.isLdapv3);
        berEncoder.encodeString(string3, this.isLdapv3);
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 111);
    }

    LdapResult extendedOp(String string, byte[] byArray, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(119);
        berEncoder.encodeString(string, 128, this.isLdapv3);
        if (byArray != null) {
            berEncoder.encodeOctetString(byArray, 129);
        }
        berEncoder.endSeq();
        LdapClient.encodeControls(berEncoder, controlArray);
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        BerDecoder berDecoder = this.conn.readReply(ldapRequest);
        berDecoder.parseSeq(null);
        berDecoder.parseInt();
        if (berDecoder.parseByte() != 120) {
            return ldapResult;
        }
        berDecoder.parseLength();
        this.parseExtResponse(berDecoder, ldapResult);
        this.conn.removeRequest(ldapRequest);
        return ldapResult;
    }

    static String getErrorMessage(int n, String string) {
        String string2 = "[LDAP: error code " + n;
        if (string != null && string.length() != 0) {
            string2 = string2 + " - " + string + "]";
        } else {
            try {
                if (ldap_error_message[n] != null) {
                    string2 = string2 + " - " + ldap_error_message[n] + "]";
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = string2 + "]";
            }
        }
        return string2;
    }

    void addUnsolicited(LdapCtx ldapCtx) {
        this.unsolicited.addElement(ldapCtx);
    }

    void removeUnsolicited(LdapCtx ldapCtx) {
        Vector vector = this.unsolicited;
        synchronized (vector) {
            if (this.unsolicited.size() == 0) {
                return;
            }
            this.unsolicited.removeElement(ldapCtx);
        }
    }

    /*
     * Unable to fully structure code
     */
    void processUnsolicited(BerDecoder var1_1) {
        var2_2 = this.unsolicited;
        synchronized (var2_2) {
            block15: {
                try {
                    var3_3 = new LdapResult();
                    var1_1.parseSeq(null);
                    var1_1.parseInt();
                    if (var1_1.parseByte() != 120) {
                        throw new IOException("Unsolicited Notification must be an Extended Response");
                    }
                    var1_1.parseLength();
                    this.parseExtResponse(var1_1, var3_3);
                    if ("1.3.6.1.4.1.1466.20036".equals(var3_3.extensionId)) {
                        this.forceClose();
                    }
                    if (this.unsolicited.size() > 0) {
                        var4_5 = new UnsolicitedResponseImpl(var3_3.extensionId, var3_3.extensionValue, var3_3.referrals, var3_3.status, var3_3.errorMessage, var3_3.matchedDN, var3_3.resControls != null ? ((LdapCtx)this.unsolicited.elementAt(0)).convertControls(var3_3.resControls) : null);
                        var5_8 = 0;
                        while (var5_8 < this.unsolicited.size()) {
                            ((LdapCtx)this.unsolicited.elementAt(var5_8)).fireUnsolicited(var4_5);
                            ++var5_8;
                        }
                        if ("1.3.6.1.4.1.1466.20036".equals(var3_3.extensionId)) {
                            var6_11 = new CommunicationException("Connection closed");
                            var7_12 = 0;
                            while (var7_12 < this.unsolicited.size()) {
                                ((LdapCtx)this.unsolicited.elementAt(var7_12)).fireUnsolicited(var6_11);
                                ++var7_12;
                            }
                            this.unsolicited.setSize(0);
                        }
                    }
                    break block15;
                }
                catch (IOException var3_4) {
                    if (this.unsolicited.size() == 0) {
                        return;
                    }
                    var4_6 = new CommunicationException("Problem parsing unsolicited notification");
                    var4_6.setRootCause(var3_4);
                    var5_9 = 0;
                    ** while (var5_9 < this.unsolicited.size())
                }
lbl-1000:
                // 1 sources

                {
                    ((LdapCtx)this.unsolicited.elementAt(var5_9)).fireUnsolicited(var4_6);
                    ++var5_9;
                    continue;
                }
lbl43:
                // 1 sources

                this.unsolicited.setSize(0);
                break block15;
                catch (NamingException var4_7) {
                    var5_10 = 0;
                    ** while (var5_10 < this.unsolicited.size())
                }
lbl-1000:
                // 1 sources

                {
                    ((LdapCtx)this.unsolicited.elementAt(var5_10)).fireUnsolicited(var4_7);
                    ++var5_10;
                    continue;
                }
lbl51:
                // 1 sources

                this.unsolicited.setSize(0);
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.conn == null) {
            throw new IOException("connection closed");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultBinaryAttrs.put("userpassword", Boolean.TRUE);
        defaultBinaryAttrs.put("javaserializeddata", Boolean.TRUE);
        defaultBinaryAttrs.put("javaserializedobject", Boolean.TRUE);
        defaultBinaryAttrs.put("jpegphoto", Boolean.TRUE);
        defaultBinaryAttrs.put("audio", Boolean.TRUE);
        defaultBinaryAttrs.put("thumbnailphoto", Boolean.TRUE);
        defaultBinaryAttrs.put("thumbnaillogo", Boolean.TRUE);
        defaultBinaryAttrs.put("usercertificate", Boolean.TRUE);
        defaultBinaryAttrs.put("cacertificate", Boolean.TRUE);
        defaultBinaryAttrs.put("certificaterevocationlist", Boolean.TRUE);
        defaultBinaryAttrs.put("authorityrevocationlist", Boolean.TRUE);
        defaultBinaryAttrs.put("crosscertificatepair", Boolean.TRUE);
        defaultBinaryAttrs.put("photo", Boolean.TRUE);
        defaultBinaryAttrs.put("personalsignature", Boolean.TRUE);
        defaultBinaryAttrs.put("x500uniqueidentifier", Boolean.TRUE);
        ldap_error_message = new String[]{"Success", "Operations Error", "Protocol Error", "Timelimit Exceeded", "Sizelimit Exceeded", "Compare False", "Compare True", "Authentication Method Not Supported", "Strong Authentication Required", null, "Referral", "Administrative Limit Exceeded", "Unavailable Critical Extension", "Confidentiality Required", "SASL Bind In Progress", null, "No Such Attribute", "Undefined Attribute Type", "Inappropriate Matching", "Constraint Violation", "Attribute Or Value Exists", "Invalid Attribute Syntax", null, null, null, null, null, null, null, null, null, null, "No Such Object", "Alias Problem", "Invalid DN Syntax", null, "Alias Dereferencing Problem", null, null, null, null, null, null, null, null, null, null, null, "Inappropriate Authentication", "Invalid Credentials", "Insufficient Access Rights", "Busy", "Unavailable", "Unwilling To Perform", "Loop Detect", null, null, null, null, null, null, null, null, null, "Naming Violation", "Object Class Violation", "Not Allowed On Non-leaf", "Not Allowed On RDN", "Entry Already Exists", "Object Class Modifications Prohibited", null, "Affects Multiple DSAs", null, null, null, null, null, null, null, null, "Other", null, null, null, null, null, null, null, null, null, null};
    }
}

