/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MotifFileChooserUI
extends BasicFileChooserUI {
    private FilterComboBoxModel filterComboBoxModel;
    protected JList directoryList = null;
    protected JList fileList = null;
    protected JTextField pathField = null;
    protected JComboBox filterComboBox = null;
    protected JTextField filenameTextField = null;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension WITH_ACCELERATOR_PREF_SIZE = new Dimension(650, 450);
    private static Dimension PREF_SIZE = new Dimension(350, 450);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension PREF_ACC_SIZE = new Dimension(10, 10);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private JPanel directoryPanel = new JPanel();
    protected JButton approveButton;
    private String enterFileNameLabelText = null;
    private int enterFileNameLabelMnemonic = 0;
    private String filesLabelText = null;
    private int filesLabelMnemonic = 0;
    private String foldersLabelText = null;
    private int foldersLabelMnemonic = 0;
    private String pathLabelText = null;
    private int pathLabelMnemonic = 0;
    private String filterLabelText = null;
    private int filterLabelMnemonic = 0;

    public MotifFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public String getDirectoryName() {
        return this.pathField.getText();
    }

    public void setDirectoryName(String string) {
        this.pathField.setText(string);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file != null) {
                        MotifFileChooserUI.this.setFileName(MotifFileChooserUI.this.getFileChooser().getName(file));
                    }
                } else if (string.equals("directoryChanged")) {
                    MotifFileChooserUI.this.directoryList.clearSelection();
                    File file = MotifFileChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        try {
                            MotifFileChooserUI.this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getCanonicalPath());
                        }
                        catch (IOException iOException) {
                            MotifFileChooserUI.this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getAbsolutePath());
                        }
                    }
                } else if (string.equals("fileSelectionChanged")) {
                    MotifFileChooserUI.this.directoryList.clearSelection();
                } else if (string == "MultiSelectionEnabledChangedProperty") {
                    if (MotifFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                        MotifFileChooserUI.this.fileList.setSelectionMode(2);
                    } else {
                        MotifFileChooserUI.this.fileList.setSelectionMode(0);
                        MotifFileChooserUI.this.fileList.clearSelection();
                        MotifFileChooserUI.this.getFileChooser().setSelectedFiles(null);
                    }
                } else if (string == "AccessoryChangedProperty") {
                    if (MotifFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent jComponent;
                        if (propertyChangeEvent.getOldValue() != null) {
                            MotifFileChooserUI.this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                        }
                        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                            MotifFileChooserUI.this.getAccessoryPanel().add((Component)jComponent, "Center");
                            MotifFileChooserUI.this.getAccessoryPanel().setPreferredSize(PREF_ACC_SIZE);
                            MotifFileChooserUI.this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
                        } else {
                            MotifFileChooserUI.this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                            MotifFileChooserUI.this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
                        }
                    }
                } else if (string == "ApproveButtonTextChangedProperty" || string == "DialogTypeChangedProperty") {
                    MotifFileChooserUI.this.approveButton.setText(MotifFileChooserUI.this.getApproveButtonText(MotifFileChooserUI.this.getFileChooser()));
                    MotifFileChooserUI.this.approveButton.setToolTipText(MotifFileChooserUI.this.getApproveButtonToolTipText(MotifFileChooserUI.this.getFileChooser()));
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifFileChooserUI((JFileChooser)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.getFileChooser().removeAll();
        super.uninstallUI(jComponent);
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setLayout(new BoxLayout(jFileChooser, 1));
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel(){

            public Insets getInsets() {
                return insets;
            }
        };
        this.align(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jFileChooser.add(jPanel);
        JLabel jLabel = new JLabel(this.pathLabelText);
        jLabel.setDisplayedMnemonic(this.pathLabelMnemonic);
        this.align(jLabel);
        jPanel.add(jLabel);
        File file = jFileChooser.getCurrentDirectory();
        String string = null;
        if (file != null) {
            string = file.getPath();
        }
        this.pathField = new JTextField(string);
        jLabel.setLabelFor(this.pathField);
        this.align(this.pathField);
        this.pathField.addActionListener(this.getUpdateAction());
        jPanel.add(this.pathField);
        jPanel.add(Box.createRigidArea(vstrut10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(MAX_SIZE);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.align(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.align(jPanel3);
        jLabel = new JLabel(this.filterLabelText);
        jLabel.setDisplayedMnemonic(this.filterLabelMnemonic);
        this.align(jLabel);
        jPanel3.add(jLabel);
        this.filterComboBox = new JComboBox();
        jLabel.setLabelFor(this.filterComboBox);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.align(this.filterComboBox);
        jPanel3.add(this.filterComboBox);
        jLabel = new JLabel(this.foldersLabelText);
        jLabel.setDisplayedMnemonic(this.foldersLabelMnemonic);
        this.align(jLabel);
        jPanel3.add(jLabel);
        JScrollPane jScrollPane = this.createDirectoryList();
        jLabel.setLabelFor(jScrollPane);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        this.align(jPanel4);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jLabel = new JLabel(this.filesLabelText);
        jLabel.setDisplayedMnemonic(this.filesLabelMnemonic);
        this.align(jLabel);
        jPanel4.add(jLabel);
        jScrollPane = this.createFilesList();
        jLabel.setLabelFor(jScrollPane);
        jPanel4.add(jScrollPane);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(hstrut10));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = this.getAccessoryPanel();
        JComponent jComponent = jFileChooser.getAccessory();
        if (jPanel5 != null) {
            if (jComponent == null) {
                jPanel5.setPreferredSize(ZERO_ACC_SIZE);
                jPanel5.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
                jPanel5.setPreferredSize(PREF_ACC_SIZE);
                jPanel5.setMaximumSize(MAX_SIZE);
            }
            this.align(jPanel5);
            jPanel2.add(jPanel5);
        }
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(vstrut10));
        jLabel = new JLabel(this.enterFileNameLabelText);
        jLabel.setDisplayedMnemonic(this.enterFileNameLabelMnemonic);
        this.align(jLabel);
        jPanel.add(jLabel);
        this.filenameTextField = new JTextField();
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        this.align(this.filenameTextField);
        this.filenameTextField.setAlignmentX(0.0f);
        jPanel.add(this.filenameTextField);
        jPanel.add(Box.createRigidArea(vstrut10));
        jFileChooser.add(new JSeparator());
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel6 = new JPanel();
        this.align(jPanel6);
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(Box.createGlue());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.align(this.approveButton);
        this.approveButton.setMargin(buttonMargin);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        jPanel6.add(this.approveButton);
        jPanel6.add(Box.createGlue());
        JButton jButton = new JButton(this.updateButtonText){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        jButton.setMnemonic(this.updateButtonMnemonic);
        jButton.setToolTipText(this.updateButtonToolTipText);
        this.align(jButton);
        jButton.setMargin(buttonMargin);
        jButton.addActionListener(this.getUpdateAction());
        jPanel6.add(jButton);
        jPanel6.add(Box.createGlue());
        JButton jButton2 = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        jButton2.setMnemonic(this.cancelButtonMnemonic);
        jButton2.setToolTipText(this.cancelButtonToolTipText);
        this.align(jButton2);
        jButton2.setMargin(buttonMargin);
        jButton2.addActionListener(this.getCancelSelectionAction());
        jPanel6.add(jButton2);
        jPanel6.add(Box.createGlue());
        JButton jButton3 = new JButton(this.helpButtonText){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        jButton3.setMnemonic(this.helpButtonMnemonic);
        jButton3.setToolTipText(this.helpButtonToolTipText);
        this.align(jButton3);
        jButton3.setMargin(buttonMargin);
        jButton3.setEnabled(false);
        jPanel6.add(jButton3);
        jPanel6.add(Box.createGlue());
        jFileChooser.add(jPanel6);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        jFileChooser.add(Box.createGlue());
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.enterFileNameLabelText = UIManager.getString("FileChooser.enterFileNameLabelText");
        this.enterFileNameLabelMnemonic = UIManager.getInt("FileChooser.enterFileNameLabelMnemonic");
        this.filesLabelText = UIManager.getString("FileChooser.filesLabelText");
        this.filesLabelMnemonic = UIManager.getInt("FileChooser.filesLabelMnemonic");
        this.foldersLabelText = UIManager.getString("FileChooser.foldersLabelText");
        this.foldersLabelMnemonic = UIManager.getInt("FileChooser.foldersLabelMnemonic");
        this.pathLabelText = UIManager.getString("FileChooser.pathLabelText");
        this.pathLabelMnemonic = UIManager.getInt("FileChooser.pathLabelMnemonic");
        this.filterLabelText = UIManager.getString("FileChooser.filterLabelText");
        this.filterLabelMnemonic = UIManager.getInt("FileChooser.filterLabelMnemonic");
    }

    protected void installIcons(JFileChooser jFileChooser) {
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
        this.fileList.setModel(new MotifFileListModel());
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.fileList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.fileList));
        this.align(this.fileList);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setPreferredSize(prefListSize);
        jScrollPane.setMaximumSize(MAX_SIZE);
        this.align(jScrollPane);
        return jScrollPane;
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryList.setModel(new MotifDirectoryListModel());
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        JScrollPane jScrollPane = new JScrollPane(this.directoryList);
        jScrollPane.setMaximumSize(MAX_SIZE);
        jScrollPane.setPreferredSize(prefListSize);
        this.align(jScrollPane);
        return jScrollPane;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.getFileChooser().getAccessory() != null) {
            return WITH_ACCELERATOR_PREF_SIZE;
        }
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void align(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        jComponent.setAlignmentY(0.0f);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = MotifFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                MotifFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = MotifFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    MotifFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return MotifFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return MotifFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }
    }

    protected class MotifFileListModel
    extends AbstractListModel
    implements ListDataListener {
        public MotifFileListModel() {
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        public int getSize() {
            return MotifFileChooserUI.this.getModel().getFiles().size();
        }

        public boolean contains(Object object) {
            return MotifFileChooserUI.this.getModel().getFiles().contains(object);
        }

        public int indexOf(Object object) {
            return MotifFileChooserUI.this.getModel().getFiles().indexOf(object);
        }

        public Object getElementAt(int n) {
            return MotifFileChooserUI.this.getModel().getFiles().elementAt(n);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    protected class MotifDirectoryListModel
    extends AbstractListModel
    implements ListDataListener {
        public MotifDirectoryListModel() {
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        public int getSize() {
            return MotifFileChooserUI.this.getModel().getDirectories().size();
        }

        public Object getElementAt(int n) {
            return MotifFileChooserUI.this.getModel().getDirectories().elementAt(n);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    protected class DirectoryCellRenderer
    extends DefaultListCellRenderer {
        protected DirectoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }
    }

    protected class FileCellRenderer
    extends DefaultListCellRenderer {
        protected FileCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }
    }
}

