/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.awt.event.MouseListener;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.DocumentLoadListener;
import org.mozilla.webclient.EventRegistration;
import org.mozilla.webclient.WindowControl;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_native.ImplObjectNative;
import org.mozilla.webclient.wrapper_native.NativeEventThread;
import org.mozilla.webclient.wrapper_native.WCEventListenerWrapper;
import org.mozilla.webclient.wrapper_native.WCMouseListenerImpl;
import org.mozilla.webclient.wrapper_native.WindowControlImpl;

public class EventRegistrationImpl
extends ImplObjectNative
implements EventRegistration {
    private NativeEventThread nativeEventThread = null;
    static /* synthetic */ Class class$org$mozilla$webclient$DocumentLoadListener;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public EventRegistrationImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl);
        try {
            WindowControl windowControl = (WindowControl)this.myBrowserControl.queryInterface("webclient.WindowControl");
            if (windowControl instanceof WindowControlImpl) {
                this.nativeEventThread = ((WindowControlImpl)windowControl).getNativeEventThread();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void delete() {
        this.nativeEventThread = null;
        super.delete();
    }

    public void addDocumentLoadListener(DocumentLoadListener documentLoadListener) {
        ParameterCheck.nonNull(documentLoadListener);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.nativeEventThread);
        ParameterCheck.nonNull(documentLoadListener);
        WCEventListenerWrapper wCEventListenerWrapper = new WCEventListenerWrapper(documentLoadListener, (class$org$mozilla$webclient$DocumentLoadListener == null ? (class$org$mozilla$webclient$DocumentLoadListener = EventRegistrationImpl.class$("org.mozilla.webclient.DocumentLoadListener")) : class$org$mozilla$webclient$DocumentLoadListener).getName());
        if (null == wCEventListenerWrapper) {
            throw new NullPointerException("Can't instantiate WCEventListenerWrapper, out of memory.");
        }
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeEventThread.addListener(wCEventListenerWrapper);
        }
    }

    public void removeDocumentLoadListener(DocumentLoadListener documentLoadListener) {
        ParameterCheck.nonNull(documentLoadListener);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.nativeEventThread);
        ParameterCheck.nonNull(documentLoadListener);
        WCEventListenerWrapper wCEventListenerWrapper = new WCEventListenerWrapper(documentLoadListener, (class$org$mozilla$webclient$DocumentLoadListener == null ? (class$org$mozilla$webclient$DocumentLoadListener = EventRegistrationImpl.class$("org.mozilla.webclient.DocumentLoadListener")) : class$org$mozilla$webclient$DocumentLoadListener).getName());
        if (null == wCEventListenerWrapper) {
            throw new NullPointerException("Can't instantiate WCEventListenerWrapper, out of memory.");
        }
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeEventThread.removeListener(wCEventListenerWrapper);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        ParameterCheck.nonNull(mouseListener);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.nativeEventThread);
        ParameterCheck.nonNull(mouseListener);
        WCMouseListenerImpl wCMouseListenerImpl = new WCMouseListenerImpl(mouseListener);
        if (null == wCMouseListenerImpl) {
            throw new NullPointerException("Can't instantiate WCMouseListenerImpl, out of memory.");
        }
        WCEventListenerWrapper wCEventListenerWrapper = new WCEventListenerWrapper(wCMouseListenerImpl, (class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = EventRegistrationImpl.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).getName());
        if (null == wCEventListenerWrapper) {
            throw new NullPointerException("Can't instantiate WCEventListenerWrapper, out of memory.");
        }
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeEventThread.addListener(wCEventListenerWrapper);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        ParameterCheck.nonNull(mouseListener);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.nativeEventThread);
        ParameterCheck.nonNull(mouseListener);
        WCMouseListenerImpl wCMouseListenerImpl = new WCMouseListenerImpl(mouseListener);
        if (null == wCMouseListenerImpl) {
            throw new NullPointerException("Can't instantiate WCMouseListenerImpl, out of memory.");
        }
        WCEventListenerWrapper wCEventListenerWrapper = new WCEventListenerWrapper(wCMouseListenerImpl, (class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = EventRegistrationImpl.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).getName());
        if (null == wCEventListenerWrapper) {
            throw new NullPointerException("Can't instantiate WCEventListenerWrapper, out of memory.");
        }
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeEventThread.removeListener(wCEventListenerWrapper);
        }
    }

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("EventRegistrationImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: EventRegistrationImpl.java,v 1.10 2001/05/29 18:36:07 ashuk%eng.sun.com Exp $");
        try {
            BrowserControlFactory.setAppData(stringArray[0]);
            BrowserControl browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            EventRegistration eventRegistration = (EventRegistration)browserControl.queryInterface("webclient.WindowControl");
            Assert.assert_it(eventRegistration != null);
        }
        catch (Exception exception) {
            System.out.println("got exception: " + exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

