/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.io.PrintWriter;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.json.JSONPrintSession;

class PrettyPrintSession
implements JSONPrintSession {
    private final PrintWriter writer;
    private final String indentString;
    private int indentLevel;
    private Position position = Position.MARGIN;

    public PrettyPrintSession(PrintWriter writer) {
        this(writer, "  ");
    }

    public PrettyPrintSession(PrintWriter writer, String indentString) {
        this.writer = writer;
        this.indentString = indentString;
    }

    @Override
    public JSONPrintSession indent() {
        ++this.indentLevel;
        return this;
    }

    @Override
    public JSONPrintSession newline() {
        if (this.position != Position.MARGIN) {
            this.writer.write(10);
            this.position = Position.MARGIN;
        }
        return this;
    }

    @Override
    public JSONPrintSession outdent() {
        --this.indentLevel;
        return this;
    }

    private void addIndentation() {
        if (this.position == Position.MARGIN) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.print(this.indentString);
            }
            this.position = Position.INDENTED;
        }
    }

    private void addSep() {
        if (this.position == Position.CONTENT) {
            this.writer.print(' ');
        }
    }

    private void prepareToPrint() {
        this.addIndentation();
        this.addSep();
    }

    @Override
    public JSONPrintSession print(String value) {
        this.prepareToPrint();
        this.writer.print(value);
        this.position = Position.CONTENT;
        return this;
    }

    @Override
    public JSONPrintSession printQuoted(String value) {
        return this.print(JSONObject.quote(value));
    }

    @Override
    public JSONPrintSession printSymbol(char symbol) {
        this.addIndentation();
        if (symbol != ',') {
            this.addSep();
        }
        this.writer.print(symbol);
        return this;
    }

    static enum Position {
        MARGIN,
        INDENTED,
        CONTENT;

    }
}

