/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Id;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.InjectionProvider2;

public class BlockInjectionProvider
implements InjectionProvider2 {
    private static final String BLOCK_TYPE_NAME = Block.class.getName();

    @Override
    public boolean provideInjection(PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
        if (!field.getTypeName().equals(BLOCK_TYPE_NAME)) {
            return false;
        }
        Id annotation = (Id)field.getAnnotation(Id.class);
        String blockId = this.getBlockId(field.getName(), annotation);
        FieldConduit<Object> conduit = this.createConduit(field, blockId);
        field.setConduit(conduit);
        return true;
    }

    private FieldConduit<Object> createConduit(PlasticField field, final String blockId) {
        String className = field.getPlasticClass().getClassName();
        String fieldName = field.getName();
        return new ReadOnlyComponentFieldConduit(className, fieldName){

            public Object get(Object instance, InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return resources.getBlock(blockId);
            }
        };
    }

    private String getBlockId(String fieldName, Id annotation) {
        return annotation != null ? annotation.value() : InternalUtils.stripMemberName((String)fieldName);
    }
}

