/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.alerts.Alert;
import org.apache.tapestry5.alerts.AlertStorage;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.base.BaseClientElement;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;

@SupportsInformalParameters
public class Alerts
extends BaseClientElement {
    @Parameter(value="message:core-dismiss-label", defaultPrefix="literal")
    private String dismissText;
    @Parameter(value="message:private-core-alerts-show-dismiss-all", defaultPrefix="literal")
    private boolean showDismissAll;
    @SessionState(create=false)
    private AlertStorage storage;
    @Inject
    private DeprecationWarning deprecationWarning;
    @Inject
    private Request request;

    void onPageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, "dismissText");
    }

    boolean beginRender(MarkupWriter writer) {
        Link dismissLink = this.resources.createEventLink("dismiss", new Object[0]);
        this.storeElement(writer.element("div", "data-container-type", "alerts", "data-show-dismiss-all", this.showDismissAll, "data-dismiss-url", dismissLink));
        this.resources.renderInformalParameters(writer);
        writer.end();
        this.addAlertsFromStorage();
        return false;
    }

    Object onDismiss(@RequestParameter(value="id", allowBlank=true) Long alertId) {
        if (this.storage != null) {
            if (alertId != null) {
                this.storage.dismiss(alertId);
            } else {
                this.storage.dismissAll();
            }
        }
        if (!this.request.isXHR()) {
            return true;
        }
        return new JSONObject();
    }

    @HeartbeatDeferred
    void addAlertsFromStorage() {
        if (this.storage == null) {
            return;
        }
        for (Alert alert : this.storage.getAlerts()) {
            this.javaScriptSupport.require("t5/core/alert").with(alert.toJSON());
        }
        this.storage.dismissNonPersistent();
    }
}

