/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.spock;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.RegistryBuilder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.spock.ExtensionModule;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Shared;
import spock.lang.Specification;

public class TapestryInterceptor
extends AbstractMethodInterceptor {
    private final SpecInfo spec;
    private final Set<Class<?>> modules;
    private Registry registry;

    public TapestryInterceptor(SpecInfo spec, Set<Class<?>> modules) {
        this.spec = spec;
        this.modules = modules;
    }

    public void interceptSharedInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.runBeforeRegistryCreatedMethods((Specification)invocation.getSharedInstance());
        this.createAndStartupRegistry();
        this.injectServices(invocation.getSharedInstance(), true);
        invocation.proceed();
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
        try {
            invocation.proceed();
        }
        finally {
            this.shutdownRegistry();
        }
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.injectServices(invocation.getInstance(), false);
        invocation.proceed();
    }

    private void runBeforeRegistryCreatedMethods(Specification spec) {
        for (Method method : this.findAllBeforeRegistryCreatedMethods()) {
            Object returnValue = ReflectionUtil.invokeMethod((Object)spec, (Method)method, (Object[])new Object[0]);
            if (!(returnValue instanceof Registry)) continue;
            this.registry = (Registry)returnValue;
        }
    }

    private void createAndStartupRegistry() {
        if (this.registry != null) {
            return;
        }
        RegistryBuilder builder = new RegistryBuilder();
        builder.add(new Class[]{ExtensionModule.class});
        for (Class<?> module : this.modules) {
            builder.add(new Class[]{module});
        }
        this.registry = builder.build();
        this.registry.performRegistryStartup();
    }

    private List<Method> findAllBeforeRegistryCreatedMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            Method method = ReflectionUtil.getDeclaredMethodByName((Class)((Class)curr.getReflection()), (String)"beforeRegistryCreated");
            if (method == null) continue;
            method.setAccessible(true);
            methods.add(method);
        }
        return methods;
    }

    private void injectServices(Object target, boolean sharedFields) throws IllegalAccessException {
        for (FieldInfo field : this.spec.getAllFields()) {
            Field rawField = (Field)field.getReflection();
            if ((rawField.isAnnotationPresent(Inject.class) || ReflectionUtil.isAnnotationPresent((AnnotatedElement)rawField, (String)"javax.inject.Inject") || rawField.isAnnotationPresent(Autobuild.class)) && rawField.isAnnotationPresent(Shared.class) == sharedFields) {
                Object value = this.registry.getObject(rawField.getType(), this.createAnnotationProvider(field));
                rawField.setAccessible(true);
                rawField.set(target, value);
                continue;
            }
            if (!rawField.isAnnotationPresent(InjectService.class)) continue;
            String serviceName = rawField.getAnnotation(InjectService.class).value();
            Object value = this.registry.getService(serviceName, rawField.getType());
            rawField.setAccessible(true);
            rawField.set(target, value);
        }
    }

    private AnnotationProvider createAnnotationProvider(final FieldInfo field) {
        return new AnnotationProvider(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)field.getAnnotation(annotationClass);
            }
        };
    }

    private void shutdownRegistry() {
        if (this.registry != null) {
            this.registry.shutdown();
        }
    }
}

