/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.commons.internal;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.services.Coercion;
import org.apache.tapestry5.commons.services.CoercionTuple;
import org.apache.tapestry5.commons.util.StringToEnumCoercion;
import org.apache.tapestry5.commons.util.TimeInterval;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.FlowOperations;

public class BasicTypeCoercions {
    public static void provideBasicTypeCoercions(MappedConfiguration<CoercionTuple.Key, CoercionTuple> configuration) {
        BasicTypeCoercions.add(configuration, Object.class, String.class, new Coercion<Object, String>(){

            @Override
            public String coerce(Object input) {
                return input.toString();
            }
        });
        BasicTypeCoercions.add(configuration, Object.class, Boolean.class, new Coercion<Object, Boolean>(){

            @Override
            public Boolean coerce(Object input) {
                return input != null;
            }
        });
        BasicTypeCoercions.add(configuration, String.class, Double.class, new Coercion<String, Double>(){

            @Override
            public Double coerce(String input) {
                return Double.valueOf(input);
            }
        });
        BasicTypeCoercions.add(configuration, String.class, BigDecimal.class, new Coercion<String, BigDecimal>(){

            @Override
            public BigDecimal coerce(String input) {
                return new BigDecimal(input);
            }
        });
        BasicTypeCoercions.add(configuration, BigDecimal.class, Double.class, new Coercion<BigDecimal, Double>(){

            @Override
            public Double coerce(BigDecimal input) {
                return input.doubleValue();
            }
        });
        BasicTypeCoercions.add(configuration, String.class, BigInteger.class, new Coercion<String, BigInteger>(){

            @Override
            public BigInteger coerce(String input) {
                return new BigInteger(input);
            }
        });
        BasicTypeCoercions.add(configuration, String.class, Long.class, new Coercion<String, Long>(){

            @Override
            public Long coerce(String input) {
                return Long.valueOf(input);
            }
        });
        BasicTypeCoercions.add(configuration, String.class, Integer.class, Integer::valueOf);
        BasicTypeCoercions.add(configuration, Long.class, Byte.class, new Coercion<Long, Byte>(){

            @Override
            public Byte coerce(Long input) {
                return input.byteValue();
            }
        });
        BasicTypeCoercions.add(configuration, Long.class, Short.class, new Coercion<Long, Short>(){

            @Override
            public Short coerce(Long input) {
                return input.shortValue();
            }
        });
        BasicTypeCoercions.add(configuration, Long.class, Integer.class, new Coercion<Long, Integer>(){

            @Override
            public Integer coerce(Long input) {
                return input.intValue();
            }
        });
        BasicTypeCoercions.add(configuration, Number.class, Long.class, new Coercion<Number, Long>(){

            @Override
            public Long coerce(Number input) {
                return input.longValue();
            }
        });
        BasicTypeCoercions.add(configuration, Double.class, Float.class, new Coercion<Double, Float>(){

            @Override
            public Float coerce(Double input) {
                return Float.valueOf(input.floatValue());
            }
        });
        BasicTypeCoercions.add(configuration, Long.class, Double.class, new Coercion<Long, Double>(){

            @Override
            public Double coerce(Long input) {
                return input.doubleValue();
            }
        });
        BasicTypeCoercions.add(configuration, String.class, Boolean.class, new Coercion<String, Boolean>(){

            @Override
            public Boolean coerce(String input) {
                String trimmed;
                String string = trimmed = input == null ? "" : input.trim();
                if (trimmed.equalsIgnoreCase("false") || trimmed.length() == 0) {
                    return false;
                }
                return true;
            }
        });
        BasicTypeCoercions.add(configuration, Number.class, Boolean.class, new Coercion<Number, Boolean>(){

            @Override
            public Boolean coerce(Number input) {
                return input.longValue() != 0L;
            }
        });
        BasicTypeCoercions.add(configuration, Void.class, Boolean.class, new Coercion<Void, Boolean>(){

            @Override
            public Boolean coerce(Void input) {
                return false;
            }
        });
        BasicTypeCoercions.add(configuration, Collection.class, Boolean.class, new Coercion<Collection, Boolean>(){

            @Override
            public Boolean coerce(Collection input) {
                return !input.isEmpty();
            }
        });
        BasicTypeCoercions.add(configuration, Object.class, List.class, new Coercion<Object, List>(){

            @Override
            public List coerce(Object input) {
                return Collections.singletonList(input);
            }
        });
        BasicTypeCoercions.add(configuration, Object[].class, List.class, new Coercion<Object[], List>(){

            @Override
            public List coerce(Object[] input) {
                return Arrays.asList(input);
            }
        });
        BasicTypeCoercions.add(configuration, Object[].class, Boolean.class, new Coercion<Object[], Boolean>(){

            @Override
            public Boolean coerce(Object[] input) {
                return input != null && input.length > 0;
            }
        });
        BasicTypeCoercions.add(configuration, Float.class, Double.class, new Coercion<Float, Double>(){

            @Override
            public Double coerce(Float input) {
                return input.doubleValue();
            }
        });
        Coercion<Object, List> primitiveArrayCoercion = new Coercion<Object, List>(){

            @Override
            public List<Object> coerce(Object input) {
                int length = Array.getLength(input);
                Object[] array = new Object[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = Array.get(input, i);
                }
                return Arrays.asList(array);
            }
        };
        BasicTypeCoercions.add(configuration, byte[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, short[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, int[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, long[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, float[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, double[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, char[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, boolean[].class, List.class, primitiveArrayCoercion);
        BasicTypeCoercions.add(configuration, String.class, File.class, new Coercion<String, File>(){

            @Override
            public File coerce(String input) {
                return new File(input);
            }
        });
        BasicTypeCoercions.add(configuration, String.class, TimeInterval.class, new Coercion<String, TimeInterval>(){

            @Override
            public TimeInterval coerce(String input) {
                return new TimeInterval(input);
            }
        });
        BasicTypeCoercions.add(configuration, TimeInterval.class, Long.class, new Coercion<TimeInterval, Long>(){

            @Override
            public Long coerce(TimeInterval input) {
                return input.milliseconds();
            }
        });
        BasicTypeCoercions.add(configuration, Object.class, Object[].class, new Coercion<Object, Object[]>(){

            @Override
            public Object[] coerce(Object input) {
                return new Object[]{input};
            }
        });
        BasicTypeCoercions.add(configuration, Collection.class, Object[].class, new Coercion<Collection, Object[]>(){

            @Override
            public Object[] coerce(Collection input) {
                return input.toArray();
            }
        });
        CoercionTuple<Flow, List> flowToListCoercion = CoercionTuple.create(Flow.class, List.class, FlowOperations::toList);
        configuration.add(flowToListCoercion.getKey(), flowToListCoercion);
        CoercionTuple<Flow, Boolean> flowToBooleanCoercion = CoercionTuple.create(Flow.class, Boolean.class, i -> !i.isEmpty());
        configuration.add(flowToBooleanCoercion.getKey(), flowToBooleanCoercion);
    }

    public static void provideJSR310TypeCoercions(MappedConfiguration<CoercionTuple.Key, CoercionTuple> configuration) {
        BasicTypeCoercions.add(configuration, Year.class, Integer.class, Year::getValue);
        BasicTypeCoercions.add(configuration, Integer.class, Year.class, Year::of);
        BasicTypeCoercions.add(configuration, Month.class, Integer.class, Month::getValue);
        BasicTypeCoercions.add(configuration, Integer.class, Month.class, Month::of);
        BasicTypeCoercions.add(configuration, String.class, Month.class, StringToEnumCoercion.create(Month.class));
        BasicTypeCoercions.add(configuration, String.class, YearMonth.class, YearMonth::parse);
        BasicTypeCoercions.add(configuration, YearMonth.class, Year.class, input -> Year.of(input.getYear()));
        BasicTypeCoercions.add(configuration, YearMonth.class, Month.class, YearMonth::getMonth);
        BasicTypeCoercions.add(configuration, String.class, MonthDay.class, MonthDay::parse);
        BasicTypeCoercions.add(configuration, MonthDay.class, Month.class, MonthDay::getMonth);
        BasicTypeCoercions.add(configuration, DayOfWeek.class, Integer.class, DayOfWeek::getValue);
        BasicTypeCoercions.add(configuration, Integer.class, DayOfWeek.class, DayOfWeek::of);
        BasicTypeCoercions.add(configuration, String.class, DayOfWeek.class, StringToEnumCoercion.create(DayOfWeek.class));
        BasicTypeCoercions.add(configuration, LocalDate.class, Instant.class, input -> input.atStartOfDay(ZoneId.systemDefault()).toInstant());
        BasicTypeCoercions.add(configuration, Instant.class, LocalDate.class, input -> input.atZone(ZoneId.systemDefault()).toLocalDate());
        BasicTypeCoercions.add(configuration, String.class, LocalDate.class, LocalDate::parse);
        BasicTypeCoercions.add(configuration, LocalDate.class, YearMonth.class, input -> YearMonth.of(input.getYear(), input.getMonth()));
        BasicTypeCoercions.add(configuration, LocalDate.class, MonthDay.class, input -> MonthDay.of(input.getMonth(), input.getDayOfMonth()));
        BasicTypeCoercions.add(configuration, LocalTime.class, Long.class, LocalTime::toNanoOfDay);
        BasicTypeCoercions.add(configuration, Long.class, LocalTime.class, LocalTime::ofNanoOfDay);
        BasicTypeCoercions.add(configuration, String.class, LocalTime.class, LocalTime::parse);
        BasicTypeCoercions.add(configuration, String.class, LocalDateTime.class, LocalDateTime::parse);
        BasicTypeCoercions.add(configuration, LocalDateTime.class, Instant.class, input -> input.atZone(ZoneId.systemDefault()).toInstant());
        BasicTypeCoercions.add(configuration, Instant.class, LocalDateTime.class, input -> LocalDateTime.ofInstant(input, ZoneId.systemDefault()));
        BasicTypeCoercions.add(configuration, LocalDateTime.class, LocalDate.class, LocalDateTime::toLocalDate);
        BasicTypeCoercions.add(configuration, String.class, OffsetDateTime.class, OffsetDateTime::parse);
        BasicTypeCoercions.add(configuration, OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant);
        BasicTypeCoercions.add(configuration, OffsetDateTime.class, OffsetTime.class, OffsetDateTime::toOffsetTime);
        BasicTypeCoercions.add(configuration, String.class, ZoneId.class, ZoneId::of);
        BasicTypeCoercions.add(configuration, String.class, ZoneOffset.class, ZoneOffset::of);
        BasicTypeCoercions.add(configuration, String.class, ZonedDateTime.class, ZonedDateTime::parse);
        BasicTypeCoercions.add(configuration, ZonedDateTime.class, Instant.class, ChronoZonedDateTime::toInstant);
        BasicTypeCoercions.add(configuration, ZonedDateTime.class, ZoneId.class, ZonedDateTime::getZone);
        BasicTypeCoercions.add(configuration, Instant.class, Long.class, Instant::toEpochMilli);
        BasicTypeCoercions.add(configuration, Long.class, Instant.class, Instant::ofEpochMilli);
        BasicTypeCoercions.add(configuration, Instant.class, Date.class, Date::from);
        BasicTypeCoercions.add(configuration, Date.class, Instant.class, Date::toInstant);
        BasicTypeCoercions.add(configuration, Duration.class, Long.class, Duration::toNanos);
        BasicTypeCoercions.add(configuration, Long.class, Duration.class, Duration::ofNanos);
        BasicTypeCoercions.add(configuration, Duration.class, TimeInterval.class, input -> {
            long millisFromSeconds = input.getSeconds() * 1000L;
            long millisFromNanos = (long)input.getNano() / 1000000L;
            return new TimeInterval(millisFromSeconds + millisFromNanos);
        });
        BasicTypeCoercions.add(configuration, TimeInterval.class, Duration.class, input -> Duration.ofMillis(input.milliseconds()));
        BasicTypeCoercions.add(configuration, String.class, Period.class, Period::parse);
    }

    private static <S, T> void add(MappedConfiguration<CoercionTuple.Key, CoercionTuple> configuration, Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        CoercionTuple<S, T> tuple = CoercionTuple.create(sourceType, targetType, coercion);
        configuration.add(tuple.getKey(), tuple);
    }
}

