/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.lang.annotation.Annotation;
import java.util.Locale;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.beanmodel.BeanModel;
import org.apache.tapestry5.beanmodel.PropertyModel;
import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanBlockSource;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FieldTranslatorSource;
import org.apache.tapestry5.services.FieldValidatorDefaultSource;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.PropertyEditContext;

public class PropertyEditor {
    private static final ComponentAction CLEANUP_ENVIRONMENT = new CleanupEnvironment();
    @Parameter(required=true, allowNull=false)
    private Object object;
    @Parameter(value="this", allowNull=false)
    private PropertyOverrides overrides;
    @Parameter(required=true)
    private String property;
    @Parameter(required=true, allowNull=false)
    private BeanModel model;
    @Inject
    private FieldValidatorDefaultSource fieldValidatorDefaultSource;
    @Inject
    private Environment environment;
    @Parameter(required=true, allowNull=false)
    private BeanBlockSource beanBlockSource;
    @Inject
    @Core
    private BeanBlockSource defaultBeanBlockSource;
    @Inject
    private Messages messages;
    @Inject
    private Locale locale;
    @Inject
    private ComponentResources resources;
    @Inject
    private FieldTranslatorSource fieldTranslatorSource;
    @Environmental
    private FormSupport formSupport;
    @Inject
    private Heartbeat heartbeat;
    private PropertyModel propertyModel;

    BeanBlockSource defaultBeanBlockSource() {
        return this.defaultBeanBlockSource;
    }

    void setupEnvironment(final String propertyName) {
        this.propertyModel = this.model.get(propertyName);
        PropertyEditContext context = new PropertyEditContext(){

            @Override
            public Messages getContainerMessages() {
                return PropertyEditor.this.overrides.getOverrideMessages();
            }

            @Override
            public String getLabel() {
                return PropertyEditor.this.propertyModel.getLabel();
            }

            @Override
            public String getPropertyId() {
                return PropertyEditor.this.propertyModel.getId();
            }

            @Override
            public Class getPropertyType() {
                return PropertyEditor.this.propertyModel.getPropertyType();
            }

            @Override
            public Object getPropertyValue() {
                return PropertyEditor.this.propertyModel.getConduit().get(PropertyEditor.this.object);
            }

            @Override
            public FieldTranslator getTranslator(Field field) {
                return PropertyEditor.this.fieldTranslatorSource.createDefaultTranslator(field, propertyName, PropertyEditor.this.overrides.getOverrideMessages(), PropertyEditor.this.locale, PropertyEditor.this.propertyModel.getPropertyType(), (AnnotationProvider)PropertyEditor.this.propertyModel.getConduit());
            }

            @Override
            public FieldValidator getValidator(Field field) {
                return PropertyEditor.this.fieldValidatorDefaultSource.createDefaultValidator(field, propertyName, PropertyEditor.this.overrides.getOverrideMessages(), PropertyEditor.this.locale, PropertyEditor.this.propertyModel.getPropertyType(), (AnnotationProvider)PropertyEditor.this.propertyModel.getConduit());
            }

            @Override
            public void setPropertyValue(Object value) {
                PropertyEditor.this.propertyModel.getConduit().set(PropertyEditor.this.object, value);
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)PropertyEditor.this.propertyModel.getAnnotation(annotationClass);
            }
        };
        this.environment.push(PropertyEditContext.class, context);
        BeanValidationContext beanValidationContext = this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext != null) {
            beanValidationContext.setCurrentProperty(propertyName);
        }
        this.heartbeat.begin();
    }

    void cleanupEnvironment() {
        this.heartbeat.end();
        this.environment.pop(PropertyEditContext.class);
    }

    void setupRender() {
        this.formSupport.storeAndExecute(this, new SetupEnvironment(this.property));
    }

    void cleanupRender() {
        this.formSupport.storeAndExecute(this, CLEANUP_ENVIRONMENT);
    }

    Block beginRender() {
        Block override = this.overrides.getOverrideBlock(this.propertyModel.getId());
        if (override != null) {
            return override;
        }
        String dataType = this.propertyModel.getDataType();
        if (dataType == null) {
            throw new RuntimeException(String.format("The data type for property '%s' of %s is null.", this.propertyModel.getPropertyName(), this.object));
        }
        try {
            return this.beanBlockSource.getEditBlock(dataType);
        }
        catch (RuntimeException ex) {
            String message = this.messages.format("core-block-error", new Object[]{this.propertyModel.getPropertyName(), dataType, this.object, ex});
            throw new TapestryException(message, this.resources.getLocation(), (Throwable)ex);
        }
    }

    boolean beforeRenderBody() {
        return false;
    }

    void inject(ComponentResources resources, PropertyOverrides overrides, PropertyModel propertyModel, BeanBlockSource beanBlockSource, Messages messages, Object object) {
        this.resources = resources;
        this.overrides = overrides;
        this.propertyModel = propertyModel;
        this.beanBlockSource = beanBlockSource;
        this.messages = messages;
        this.object = object;
    }

    static class CleanupEnvironment
    implements ComponentAction<PropertyEditor> {
        private static final long serialVersionUID = 7878694042753046523L;

        CleanupEnvironment() {
        }

        @Override
        public void execute(PropertyEditor component) {
            component.cleanupEnvironment();
        }

        public String toString() {
            return "PropertyEditor.CleanupEnvironment";
        }
    }

    static class SetupEnvironment
    implements ComponentAction<PropertyEditor> {
        private static final long serialVersionUID = 5337049721509981997L;
        private final String property;

        public SetupEnvironment(String property) {
            this.property = property;
        }

        @Override
        public void execute(PropertyEditor component) {
            component.setupEnvironment(this.property);
        }

        public String toString() {
            return String.format("PropertyEditor.SetupEnvironment[%s]", this.property);
        }
    }
}

