/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.internal.webresources.AbstractMinimizer;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.webresources.GoogleClosureMinimizerOptionsProvider;
import org.slf4j.Logger;

public class GoogleClosureMinimizer
extends AbstractMinimizer {
    private final List<SourceFile> EXTERNS = Collections.emptyList();
    private final Request request;
    private final GoogleClosureMinimizerOptionsProvider optionsProvider;

    public GoogleClosureMinimizer(Logger logger, OperationTracker tracker, AssetChecksumGenerator checksumGenerator, Request request, GoogleClosureMinimizerOptionsProvider optionsProvider) {
        super(logger, tracker, checksumGenerator, "text/javascript");
        this.request = request;
        this.optionsProvider = optionsProvider;
    }

    @Override
    protected boolean isEnabled(StreamableResource resource) {
        return this.request.getAttribute("tapestry.disable-javascript-minimization") == null;
    }

    @Override
    protected InputStream doMinimize(StreamableResource resource) throws IOException {
        Optional<CompilerOptions> maybeOptions = this.optionsProvider.providerOptions(resource);
        if (!maybeOptions.isPresent()) {
            try (InputStream is = resource.openStream();){
                InputStream inputStream = is;
                return inputStream;
            }
        }
        CompilerOptions options = maybeOptions.get();
        options.setOutputCharset(StandardCharsets.UTF_8);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        SourceFile input = SourceFile.fromInputStream((String)resource.toString(), (InputStream)resource.openStream(), (Charset)StandardCharsets.UTF_8);
        List<SourceFile> inputs = Collections.singletonList(input);
        Result result = compiler.compile(this.EXTERNS, inputs, options);
        if (result.success) {
            return IOUtils.toInputStream((String)compiler.toSource(), (Charset)StandardCharsets.UTF_8);
        }
        throw new RuntimeException(String.format("Compilation failed: %s.", InternalUtils.join((List)CollectionFactory.newList((Collection)result.errors), (String)";")));
    }

    static {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
    }
}

