/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.Stack;
import org.apache.tapestry5.services.Context;

public class ContextImpl
implements Context {
    private final ServletContext servletContext;

    public ContextImpl(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public URL getResource(String path) {
        try {
            return this.servletContext.getResource(path);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public File getRealFile(String path) {
        String realPath = this.servletContext.getRealPath(path);
        return realPath == null ? null : new File(realPath);
    }

    @Override
    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    @Override
    public List<String> getResourcePaths(String path) {
        List result = CollectionFactory.newList();
        Stack queue = CollectionFactory.newStack();
        queue.push((Object)path);
        while (!queue.isEmpty()) {
            String current = (String)queue.pop();
            Set matches = this.servletContext.getResourcePaths(current);
            if (matches == null) continue;
            for (String match : matches) {
                if (match.endsWith("/")) {
                    queue.push((Object)match);
                    continue;
                }
                result.add(match);
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public Object getAttribute(String name) {
        return this.servletContext.getAttribute(name);
    }

    @Override
    public List<String> getAttributeNames() {
        return InternalUtils.toList((Enumeration)this.servletContext.getAttributeNames());
    }

    @Override
    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }
}

