/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.base;

import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.services.BeanBlockSource;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.PropertyOutputContext;

public abstract class AbstractPropertyOutput {
    @Parameter(required=true, allowNull=false)
    private PropertyModel model;
    @Parameter(required=true, allowNull=false)
    private PropertyOverrides overrides;
    @Parameter(required=true)
    private Object object;
    @Parameter(required=true, allowNull=false)
    private BeanBlockSource beanBlockSource;
    @Inject
    @Core
    private BeanBlockSource defaultBeanBlockSource;
    @Inject
    private Environment environment;
    private boolean mustPopEnvironment;
    @Inject
    private ComponentResources resources;

    BeanBlockSource defaultBeanBlockSource() {
        return this.defaultBeanBlockSource;
    }

    protected PropertyModel getPropertyModel() {
        return this.model;
    }

    protected Object renderPropertyValue(MarkupWriter writer, String overrideBlockId) {
        String text;
        Block override = this.overrides.getOverrideBlock(overrideBlockId);
        if (override != null) {
            return override;
        }
        String datatype = this.model.getDataType();
        if (this.beanBlockSource.hasDisplayBlock(datatype)) {
            PropertyOutputContext context = new PropertyOutputContext(){

                @Override
                public Messages getMessages() {
                    return AbstractPropertyOutput.this.overrides.getOverrideMessages();
                }

                @Override
                public Object getPropertyValue() {
                    return AbstractPropertyOutput.this.readPropertyForObject();
                }

                @Override
                public String getPropertyId() {
                    return AbstractPropertyOutput.this.model.getId();
                }

                @Override
                public String getPropertyName() {
                    return AbstractPropertyOutput.this.model.getPropertyName();
                }
            };
            this.environment.push(PropertyOutputContext.class, context);
            this.mustPopEnvironment = true;
            return this.beanBlockSource.getDisplayBlock(datatype);
        }
        Object value = this.readPropertyForObject();
        String string = text = value == null ? "" : value.toString();
        if (InternalUtils.isNonBlank((String)text)) {
            writer.write(text);
        }
        return false;
    }

    Object readPropertyForObject() {
        PropertyConduit conduit = this.model.getConduit();
        try {
            return conduit == null ? null : conduit.get(this.object);
        }
        catch (NullPointerException ex) {
            throw new TapestryException(String.format("Property '%s' contains a null value in the path.", this.model.getPropertyName()), this.resources.getLocation(), (Throwable)ex);
        }
    }

    boolean beforeRenderTemplate() {
        return false;
    }

    void afterRender() {
        if (this.mustPopEnvironment) {
            this.environment.pop(PropertyOutputContext.class);
            this.mustPopEnvironment = false;
        }
    }

    void inject(PropertyModel model, Object object, ComponentResources resources) {
        this.model = model;
        this.object = object;
        this.resources = resources;
    }
}

