/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Max;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MaxValidatorForNumber
implements ConstraintValidator<Max, Number> {
    private long max;

    @Override
    public void initialize(Max annotation) {
        this.max = annotation.value();
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(this.max)) < 1;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(this.max)) < 1;
        }
        return value.longValue() <= this.max;
    }
}

